"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManualConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _dedent = _interopRequireDefault(require("dedent"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _searchConnectors = require("@kbn/search-connectors");
var _tryInConsole = require("@kbn/try-in-console");
var _new_connector_logic = require("../../../new_index/method_connector/new_connector_logic");
var _manual_configuration_flyout = require("./manual_configuration_flyout");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/create_connector/components/manual_configuration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ManualConfiguration = ({
  isDisabled,
  selfManagePreference
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      http,
      application
    }
  } = (0, _public.useKibana)();
  const {
    plugins: {
      share,
      console
    }
  } = (0, _app_context.useAppContext)();
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const splitButtonPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'splitButtonPopover'
  });
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const {
    selectedConnector,
    rawName
  } = (0, _kea.useValues)((0, _new_connector_logic.NewConnectorLogic)({
    http,
    navigateToUrl: application === null || application === void 0 ? void 0 : application.navigateToUrl
  }));
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const [flyoutContent, setFlyoutContent] = (0, _react.useState)();
  const getCodeSnippet = () => {
    const connectorInfo = selectedConnector !== null && selectedConnector !== void 0 && selectedConnector.serviceType ? _searchConnectors.NATIVE_CONNECTOR_DEFINITIONS[selectedConnector.serviceType] : undefined;
    if (!connectorInfo) {
      return '';
    }
    const dynamicConfigValues = Object.entries(connectorInfo.configuration).map(([key, config]) => {
      const defaultValue = config ? JSON.stringify(config.value) : null;
      return `    "${key}": ${defaultValue}`;
    }).join(',\n');
    const CONSOLE_SNIPPET = (0, _dedent.default)` # Example of how to create a ${connectorInfo === null || connectorInfo === void 0 ? void 0 : connectorInfo.name} connector using the API
# This also creates related resources like an index and an API key.
# This is an alternative to using the UI creation flow.

# 1. Create an index
PUT connector-${rawName}
{
  "settings": {
    "index": {
      "number_of_shards": 3,
      "number_of_replicas": 2
    }
  }
}  
# 2. Create a connector
PUT _connector/${rawName}
{
  "name": "My ${connectorInfo === null || connectorInfo === void 0 ? void 0 : connectorInfo.name} connector",
  "index_name":  "connector-${rawName}",
  "service_type": "${selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.serviceType}"
}
# 3. Create an API key
POST /_security/api_key
{
  "name": "${rawName}-api-key",
  "role_descriptors": {
    "${selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.serviceType}-api-key-role": {
      "cluster": [
        "monitor",
        "manage_connector"
      ],
      "indices": [
        {
          "names": [
            "connector-${rawName}",
            ".search-acl-filter-connector-${rawName}",
            ".elastic-connectors*"
          ],
          "privileges": [
            "all"
          ],
          "allow_restricted_indices": false
        }
      ]
    }
  }
}

# 🔧 Configure your connector
# NOTE: Configuration keys differ per service type.
PUT _connector/${rawName}/_configuration
{
  "values": {
${dynamicConfigValues}
  }
}

# 🔌 Verify your connector is connected
GET _connector/${rawName}

# 🔄 Sync data
POST _connector/_sync_job
{
  "id": "${rawName}",
  "job_type": "full"
}

# ⏳ Check sync status
GET _connector/_sync_job?connector_id=${rawName}&size=1

# Once the job completes, the status should return completed
# 🎉 Verify that data is present in the index with the following API call 
GET connector-${rawName}/_count

# 🔎 Elasticsearch stores data in documents, which are JSON objects. List the individual documents with the following API call
GET connector-${rawName}/_search
`;
    return CONSOLE_SNIPPET;
  };
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "copy",
    icon: "wrench",
    onClick: () => {
      setFlyoutContent('manual_config');
      setIsFlyoutVisible(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.manageAttachedIndexContextMenuItemLabel', {
    defaultMessage: 'Manual configuration'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "edit",
    icon: "console",
    onClick: () => {
      closePopover();
    },
    css: (0, _react2.css)`
        .euiLink {
          color: ${euiTheme.colors.text};
          font-weight: ${euiTheme.font.weight.regular};
        }
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
    application: application,
    sharePlugin: share,
    consolePlugin: console,
    content: _i18n.i18n.translate('xpack.contentConnectors.createConnector.flyoutManualConfigContent.TryInConsoleLabel', {
      defaultMessage: 'Run in Console'
    }),
    type: "link",
    request: getCodeSnippet(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "share",
    icon: "console",
    onClick: () => {
      setFlyoutContent('client');
      setIsFlyoutVisible(true);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.scheduleASyncContextMenuItemLabel', {
    defaultMessage: 'Try with CLI'
  }))];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: splitButtonPopoverId,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "enterpriseSearchFinishUpStepButton",
      display: "fill",
      disabled: isDisabled,
      size: "m",
      iconType: "boxesVertical",
      "aria-label": _i18n.i18n.translate('xpack.contentConnectors.createConnector.finishUpStep.euiButtonIcon.moreLabel', {
        defaultMessage: 'More'
      }),
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 11
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 9
    }
  })), isFlyoutVisible && /*#__PURE__*/_react.default.createElement(_manual_configuration_flyout.ManualConfigurationFlyout, {
    setIsFlyoutVisible: setIsFlyoutVisible,
    flyoutContent: flyoutContent,
    selfManagePreference: selfManagePreference,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }));
};
exports.ManualConfiguration = ManualConfiguration;