"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTab = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _std = require("@kbn/std");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/findings_flyout/table_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getDescriptionDisplay = value => {
  if (value === undefined) return 'undefined';
  if (typeof value === 'boolean' || value === null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 23,
        columnNumber: 12
      }
    }, JSON.stringify(value));
  }
  if (typeof value === 'object') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      isCopyable: true,
      overflowHeight: 300,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }, JSON.stringify(value, null, 2));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 10
    }
  }, value);
};
const search = {
  box: {
    incremental: true
  }
};
const sorting = {
  sort: {
    field: 'key',
    direction: 'asc'
  }
};
const pagination = {
  initialPageSize: 100,
  showPerPageOptions: false
};
const columns = [{
  field: 'key',
  name: _i18n.i18n.translate('xpack.csp.flyout.tableTab.fieldLabel', {
    defaultMessage: 'Field'
  }),
  width: '25%'
}, {
  field: 'value',
  name: _i18n.i18n.translate('xpack.csp.flyout.tableTab.fieldValueLabel', {
    defaultMessage: 'Value'
  }),
  render: (value, record) => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: '100%'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 32
    }
  }, getDescriptionDisplay(value))
}];
const getFlattenedItems = resource => Object.entries((0, _std.getFlattenedObject)(resource)).map(([key, value]) => ({
  key,
  value
}));
const TableTab = ({
  data
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
  items: getFlattenedItems(data),
  columns: columns,
  sorting: sorting,
  search: search,
  pagination: pagination,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 72,
    columnNumber: 3
  }
});
exports.TableTab = TableTab;