"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservableFormFields = exports.ObservableForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _constants = require("../../../common/constants");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var i18n = _interopRequireWildcard(require("./translations"));
var _fields_config = require("./fields_config");
var _builder = require("./builder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/observables/observable_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ObservableFormFields = exports.ObservableFormFields = /*#__PURE__*/(0, _react.memo)(({
  observable
}) => {
  var _observable$typeKey;
  const {
    data,
    isLoading
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const [selectedTypeKey, setSelectedTypeKey] = (0, _react.useState)((_observable$typeKey = observable === null || observable === void 0 ? void 0 : observable.typeKey) !== null && _observable$typeKey !== void 0 ? _observable$typeKey : '');
  const {
    validateFields
  } = (0, _hook_form_lib.useFormContext)();
  const options = (0, _react.useMemo)(() => {
    return [..._constants.OBSERVABLE_TYPES_BUILTIN, ...data.observableTypes].map(observableType => ({
      value: observableType.key,
      inputDisplay: observableType.label
    }));
  }, [data.observableTypes]);
  const handleSelectedTypeChange = (0, _react.useCallback)(selectedTypeKeyValue => {
    validateFields(['value']);
    setSelectedTypeKey(selectedTypeKeyValue);
  }, [validateFields]);

  // NOTE: dynamic, because of field config changes, depending on the selectedTypeKey
  const ValueComponent = (0, _react.useMemo)(() => (0, _builder.getDynamicValueField)((0, _fields_config.normalizeValueType)(selectedTypeKey)), [selectedTypeKey]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !observable && /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    component: _components.SuperSelectField,
    componentProps: {
      euiFieldProps: {
        options,
        isLoading,
        'data-test-subj': 'observable-type-select',
        placeholder: i18n.SELECT_OBSERVABLE_TYPE_PLACEHOLDER
      }
    },
    onChange: handleSelectedTypeChange,
    path: "typeKey",
    config: _fields_config.fieldsConfig.typeKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ValueComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "description",
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'observable-description-text-area',
        placeholder: i18n.SELECT_OBSERVABLE_DESCRIPTION_PLACEHOLDER
      }
    },
    config: _fields_config.fieldsConfig.description,
    component: _components.TextAreaField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
});
ObservableFormFields.displayName = 'ObservableFormFields';
const ObservableForm = ({
  isLoading,
  onSubmit,
  observable,
  onCancel
}) => {
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: observable !== null && observable !== void 0 ? observable : {
      typeKey: '',
      value: '',
      description: ''
    },
    options: {
      stripEmptyFields: false
    }
  });
  const handleSubmitClick = (0, _react.useCallback)(async e => {
    const {
      isValid,
      data
    } = await form.submit(e);
    if (isValid) {
      return onSubmit({
        ...data
      });
    }
  }, [form, onSubmit]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ObservableFormFields, {
    observable: observable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, i18n.CANCEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "save-observable",
    onClick: handleSubmitClick,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, observable ? i18n.SAVE_OBSERVABLE : i18n.ADD_OBSERVABLE)));
};
exports.ObservableForm = ObservableForm;
ObservableForm.displayName = 'ObservableForm';