"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visdimension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _i18n2 = require("../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/vis_dimension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  VisDimension: strings
} = _i18n2.ArgumentStrings;
const VisDimensionArgInput = ({
  argValue,
  typeInstance,
  onValueChange,
  resolved: {
    columns
  }
}) => {
  var _typeInstance$options, _value$chain$0$argume, _value$chain$0$argume2, _value$chain$0$argume3, _columns$selectedValu, _columns$find;
  const [value, setValue] = (0, _react.useState)(argValue);
  const confirm = typeInstance === null || typeInstance === void 0 ? void 0 : (_typeInstance$options = typeInstance.options) === null || _typeInstance$options === void 0 ? void 0 : _typeInstance$options.confirm;
  (0, _react.useEffect)(() => {
    setValue(argValue);
  }, [argValue]);
  const onChange = (0, _react.useCallback)(ev => {
    const onChangeFn = confirm ? setValue : onValueChange;
    const astObj = {
      type: 'expression',
      chain: [{
        type: 'function',
        function: 'visdimension',
        arguments: {
          _: [ev.target.value]
        }
      }]
    };
    onChangeFn(typeof value === 'string' ? ev.target.value : astObj);
  }, [confirm, onValueChange, value]);
  const options = [{
    value: '',
    text: strings.getDefaultOptionName(),
    disabled: true
  }, ...columns.map(column => ({
    value: column.id,
    text: column.name
  }))];
  const selectedValue = typeof value === 'string' ? value : (_value$chain$0$argume = (_value$chain$0$argume2 = value.chain[0].arguments._) === null || _value$chain$0$argume2 === void 0 ? void 0 : _value$chain$0$argume2[0]) !== null && _value$chain$0$argume !== void 0 ? _value$chain$0$argume : (_value$chain$0$argume3 = value.chain[0].arguments.accessor) === null || _value$chain$0$argume3 === void 0 ? void 0 : _value$chain$0$argume3[0];
  const columnId = typeof selectedValue === 'number' ? ((_columns$selectedValu = columns[selectedValue]) === null || _columns$selectedValu === void 0 ? void 0 : _columns$selectedValu.id) || '' : ((_columns$find = columns.find(({
    id
  }) => id === selectedValue)) === null || _columns$find === void 0 ? void 0 : _columns$find.id) || '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    options: options,
    value: columnId,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.canvas.visDimensionArgInput.dimensionSelect.ariaLabel', {
      defaultMessage: 'Dimension'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })), confirm && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: () => onValueChange(value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, confirm)));
};
const visdimension = () => ({
  name: 'vis_dimension',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  simpleTemplate: (0, _template_from_react_component.templateFromReactComponent)(VisDimensionArgInput)
});
exports.visdimension = visdimension;