"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectAnomalyDetector = SelectAnomalyDetector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/rule_types/anomaly_rule_type/select_anomaly_detector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SelectAnomalyDetector({
  values,
  onChange
}) {
  const options = _apm_rule_types.ANOMALY_DETECTOR_SELECTOR_OPTIONS.map(option => ({
    key: option.type,
    label: option.label,
    checked: values.includes(option.type) ? 'on' : undefined
  }));
  const onOptionSelect = (0, _react.useCallback)(selectedOptions => {
    const selectedTypes = selectedOptions.filter(({
      checked
    }) => checked === 'on').map(({
      key
    }) => key);
    onChange(selectedTypes);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    onChange: onOptionSelect,
    style: {
      width: 200
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, list => list);
}