"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleNotifyWhenAttributes = exports.ruleLastRunOutcomeValuesAttributes = exports.ruleExecutionStatusWarningReasonAttributes = exports.ruleExecutionStatusValuesAttributes = exports.ruleExecutionStatusErrorReasonAttributes = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleNotifyWhenAttributes = exports.ruleNotifyWhenAttributes = {
  CHANGE: 'onActionGroupChange',
  ACTIVE: 'onActiveAlert',
  THROTTLE: 'onThrottleInterval'
};
const ruleLastRunOutcomeValuesAttributes = exports.ruleLastRunOutcomeValuesAttributes = {
  SUCCEEDED: 'succeeded',
  WARNING: 'warning',
  FAILED: 'failed'
};
const ruleExecutionStatusValuesAttributes = exports.ruleExecutionStatusValuesAttributes = {
  OK: 'ok',
  ACTIVE: 'active',
  ERROR: 'error',
  WARNING: 'warning',
  PENDING: 'pending',
  UNKNOWN: 'unknown'
};
const ruleExecutionStatusErrorReasonAttributes = exports.ruleExecutionStatusErrorReasonAttributes = {
  READ: 'read',
  DECRYPT: 'decrypt',
  EXECUTE: 'execute',
  UNKNOWN: 'unknown',
  LICENSE: 'license',
  TIMEOUT: 'timeout',
  DISABLED: 'disabled',
  VALIDATE: 'validate'
};
const ruleExecutionStatusWarningReasonAttributes = exports.ruleExecutionStatusWarningReasonAttributes = {
  MAX_EXECUTABLE_ACTIONS: 'maxExecutableActions',
  MAX_ALERTS: 'maxAlerts',
  MAX_QUEUED_ACTIONS: 'maxQueuedActions',
  EXECUTION: 'ruleExecution'
};