"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRateAnalysisAppState = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _mlUrlState = require("@kbn/ml-url-state");
var _public = require("@kbn/kibana-utils-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _common = require("@kbn/data-plugin/common");
var _state = require("@kbn/aiops-log-rate-analysis/state");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _use_data_source = require("../../hooks/use_data_source");
var _storage = require("../../types/storage");
var _log_rate_analysis_page = require("./log_rate_analysis_page");
var _time_series_dataview_check = require("../../application/utils/time_series_dataview_check");
var _use_filters_query = require("../../hooks/use_filters_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763899475283842490/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_rate_analysis/log_rate_analysis_app_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const localStorage = new _public.Storage(window.localStorage);

/**
 * Props for the LogRateAnalysisAppState component.
 */

const LogRateAnalysisAppState = ({
  dataView,
  savedSearch,
  appContextValue,
  showContextualInsights = false,
  showFrozenDataTierChoice = true
}) => {
  var _appContextValue$case, _appContextValue$case2, _appContextValue$case3;
  if (!dataView) return null;
  const warning = (0, _time_series_dataview_check.timeSeriesDataViewWarning)(dataView, 'log_rate_analysis');
  if (warning !== null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, warning);
  }
  const CasesContext = (_appContextValue$case = (_appContextValue$case2 = appContextValue.cases) === null || _appContextValue$case2 === void 0 ? void 0 : _appContextValue$case2.ui.getCasesContext()) !== null && _appContextValue$case !== void 0 ? _appContextValue$case : _react.default.Fragment;
  const casesPermissions = (_appContextValue$case3 = appContextValue.cases) === null || _appContextValue$case3 === void 0 ? void 0 : _appContextValue$case3.helpers.canUseCases();
  const datePickerDeps = {
    ...(0, _lodash.pick)(appContextValue, ['data', 'http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice
  };
  return /*#__PURE__*/_react.default.createElement(_use_aiops_app_context.AiopsAppContext.Provider, {
    value: appContextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CasesContext, {
    permissions: casesPermissions,
    owner: [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_mlUrlState.UrlStateProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_data_source.DataSourceContext.Provider, {
    value: {
      dataView,
      savedSearch
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_state.LogRateAnalysisReduxProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlLocalStorage.StorageContextProvider, {
    storage: localStorage,
    storageKeys: _storage.AIOPS_STORAGE_KEYS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_use_filters_query.FilterQueryContextProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_log_rate_analysis_page.LogRateAnalysisPage, {
    showContextualInsights: showContextualInsights,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 21
    }
  })))))))));
};
exports.LogRateAnalysisAppState = LogRateAnalysisAppState;