/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

package org.elasticsearch.transport;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.rest.RestStatus;

import java.io.IOException;

public class ReceiveTimeoutTransportException extends ActionTransportException {

    public ReceiveTimeoutTransportException(DiscoveryNode node, String action, String msg) {
        super(node.getName(), node.getAddress(), action, msg, null);
    }

    public ReceiveTimeoutTransportException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        // stack trace is uninformative
        return this;
    }

    @Override
    public RestStatus status() {
        // closest thing to "your request took longer than you asked for"
        return RestStatus.TOO_MANY_REQUESTS;
    }

    @Override
    public boolean isTimeout() {
        return true;
    }
}
