/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.spatial;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.spatial.CentroidPointAggregator;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointSourceValuesAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("xVal", ElementType.DOUBLE), new IntermediateStateDesc("xDel", ElementType.DOUBLE), new IntermediateStateDesc("yVal", ElementType.DOUBLE), new IntermediateStateDesc("yDel", ElementType.DOUBLE), new IntermediateStateDesc("count", ElementType.LONG));
    private final CentroidPointAggregator.GroupingCentroidState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction(List<Integer> channels, CentroidPointAggregator.GroupingCentroidState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction(channels, SpatialCentroidCartesianPointSourceValuesAggregator.initGrouping(driverContext.bigArrays()), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock wkbBlock = (BytesRefBlock)page.getBlock(this.channels.get(0));
        final BytesRefVector wkbVector = wkbBlock.asVector();
        if (wkbVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, wkbBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                SpatialCentroidCartesianPointSourceValuesGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, wkbVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefBlock wkbBlock) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || wkbBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int wkbStart = wkbBlock.getFirstValueIndex(valuesPosition);
                int wkbEnd = wkbStart + wkbBlock.getValueCount(valuesPosition);
                for (int wkbOffset = wkbStart; wkbOffset < wkbEnd; ++wkbOffset) {
                    BytesRef wkbValue = wkbBlock.getBytesRef(wkbOffset, wkbScratch);
                    SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, BytesRefVector wkbVector) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef wkbValue = wkbVector.getBytesRef(valuesPosition, wkbScratch);
                SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialCentroidCartesianPointSourceValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefBlock wkbBlock) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || wkbBlock.isNull(valuesPosition = groupPosition + positionOffset)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int wkbStart = wkbBlock.getFirstValueIndex(valuesPosition);
                int wkbEnd = wkbStart + wkbBlock.getValueCount(valuesPosition);
                for (int wkbOffset = wkbStart; wkbOffset < wkbEnd; ++wkbOffset) {
                    BytesRef wkbValue = wkbBlock.getBytesRef(wkbOffset, wkbScratch);
                    SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, BytesRefVector wkbVector) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                BytesRef wkbValue = wkbVector.getBytesRef(valuesPosition, wkbScratch);
                SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                SpatialCentroidCartesianPointSourceValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefBlock wkbBlock) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (wkbBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int wkbStart = wkbBlock.getFirstValueIndex(valuesPosition);
            int wkbEnd = wkbStart + wkbBlock.getValueCount(valuesPosition);
            for (int wkbOffset = wkbStart; wkbOffset < wkbEnd; ++wkbOffset) {
                BytesRef wkbValue = wkbBlock.getBytesRef(wkbOffset, wkbScratch);
                SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, BytesRefVector wkbVector) {
        BytesRef wkbScratch = new BytesRef();
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            BytesRef wkbValue = wkbVector.getBytesRef(valuesPosition, wkbScratch);
            SpatialCentroidCartesianPointSourceValuesAggregator.combine(this.state, groupId, wkbValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object xValUncast = page.getBlock(this.channels.get(0));
        if (xValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xVal = ((DoubleBlock)xValUncast).asVector();
        Object xDelUncast = page.getBlock(this.channels.get(1));
        if (xDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector xDel = ((DoubleBlock)xDelUncast).asVector();
        Object yValUncast = page.getBlock(this.channels.get(2));
        if (yValUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yVal = ((DoubleBlock)yValUncast).asVector();
        Object yDelUncast = page.getBlock(this.channels.get(3));
        if (yDelUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector yDel = ((DoubleBlock)yDelUncast).asVector();
        Object countUncast = page.getBlock(this.channels.get(4));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (xVal.getPositionCount() == xDel.getPositionCount() && xVal.getPositionCount() == yVal.getPositionCount() && xVal.getPositionCount() == yDel.getPositionCount() && xVal.getPositionCount() == count.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            SpatialCentroidCartesianPointSourceValuesAggregator.combineIntermediate(this.state, groupId, xVal.getDouble(valuesPosition), xDel.getDouble(valuesPosition), yVal.getDouble(valuesPosition), yDel.getDouble(valuesPosition), count.getLong(valuesPosition));
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, BytesRefBlock wkbBlock) {
        if (wkbBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = SpatialCentroidCartesianPointSourceValuesAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

