/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.dfs.DfsSearchResult;

public class AggregatedDfs
implements Writeable {
    private final Map<Term, TermStatistics> termStatistics;
    private final Map<String, CollectionStatistics> fieldStatistics;
    private final long maxDoc;

    public AggregatedDfs(StreamInput in) throws IOException {
        int size = in.readVInt();
        this.termStatistics = new HashMap<Term, TermStatistics>(size);
        for (int i = 0; i < size; ++i) {
            Term term = new Term(in.readString(), in.readSlicedBytesReference().toBytesRef());
            TermStatistics stats = new TermStatistics(in.readBytesRef(), in.readVLong(), DfsSearchResult.subOne(in.readVLong()));
            this.termStatistics.put(term, stats);
        }
        this.fieldStatistics = DfsSearchResult.readFieldStats(in);
        this.maxDoc = in.readVLong();
    }

    public AggregatedDfs(Map<Term, TermStatistics> termStatistics, Map<String, CollectionStatistics> fieldStatistics, long maxDoc) {
        this.termStatistics = termStatistics;
        this.fieldStatistics = fieldStatistics;
        this.maxDoc = maxDoc;
    }

    public Map<Term, TermStatistics> termStatistics() {
        return this.termStatistics;
    }

    public Map<String, CollectionStatistics> fieldStatistics() {
        return this.fieldStatistics;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.termStatistics, (o, k) -> {
            o.writeString(k.field());
            o.writeBytesRef(k.bytes());
        }, (o, v) -> {
            o.writeBytesRef(v.term());
            o.writeVLong(v.docFreq());
            o.writeVLong(DfsSearchResult.addOne(v.totalTermFreq()));
        });
        DfsSearchResult.writeFieldStats(out, this.fieldStatistics);
        out.writeVLong(this.maxDoc);
    }
}

