/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.ProjectScopedSettings;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.injection.guice.Binder;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class SettingsModule
implements Module {
    private static final Logger logger = LogManager.getLogger(SettingsModule.class);
    private final Settings settings;
    private final Set<String> settingsFilterPattern = new HashSet<String>();
    private final Map<String, Setting<?>> nodeSettings = new HashMap();
    private final Map<String, Setting<?>> projectSettings = new HashMap();
    private final Map<String, Setting<?>> indexSettings = new HashMap();
    private final Set<Setting<?>> consistentSettings = new HashSet();
    private final IndexScopedSettings indexScopedSettings;
    private final ClusterSettings clusterSettings;
    private final ProjectScopedSettings projectScopedSettings;
    private final SettingsFilter settingsFilter;

    public SettingsModule(Settings settings, Setting<?> ... additionalSettings) {
        this(settings, Arrays.asList(additionalSettings), Collections.emptyList());
    }

    public SettingsModule(Settings settings, List<Setting<?>> additionalSettings, List<String> settingsFilter) {
        this(settings, additionalSettings, settingsFilter, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS, IndexScopedSettings.BUILT_IN_INDEX_SETTINGS);
    }

    SettingsModule(Settings settings, List<Setting<?>> additionalSettings, List<String> settingsFilter, Set<Setting<?>> registeredClusterSettings, Set<Setting<?>> registeredIndexSettings) {
        this.settings = settings;
        for (Setting<?> setting : registeredClusterSettings) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : registeredIndexSettings) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : additionalSettings) {
            this.registerSetting(setting);
        }
        for (String filter : settingsFilter) {
            this.registerSettingsFilter(filter);
        }
        this.indexScopedSettings = new IndexScopedSettings(settings, new HashSet(this.indexSettings.values()));
        this.clusterSettings = new ClusterSettings(settings, new HashSet(this.nodeSettings.values()));
        this.projectScopedSettings = new ProjectScopedSettings(settings, new HashSet(this.projectSettings.values()));
        Settings indexSettings = settings.filter(s -> s.startsWith("index.") && this.clusterSettings.get((String)s) == null);
        if (!indexSettings.isEmpty()) {
            try {
                String separator = IntStream.range(0, 85).mapToObj(s -> "*").collect(Collectors.joining("")).trim();
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                builder.append("Found index level settings on node level configuration.");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                int count = 0;
                for (String word : "Since elasticsearch 5.x index level settings can NOT be set on the nodes configuration like the elasticsearch.yaml, in system properties or command line arguments.In order to upgrade all indices the settings must be updated via the /${index}/_settings API. Unless all settings are dynamic all indices must be closed in order to apply the upgradeIndices created in the future should use index templates to set default values.".split(" ")) {
                    if (count + word.length() > 85) {
                        builder.append(System.lineSeparator());
                        count = 0;
                    }
                    count += word.length() + 1;
                    builder.append(word).append(" ");
                }
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("Please ensure all required values are updated on all indices by executing: ");
                builder.append(System.lineSeparator());
                builder.append(System.lineSeparator());
                builder.append("curl -XPUT 'http://localhost:9200/_all/_settings?preserve_existing=true' -d '");
                try (XContentBuilder xContentBuilder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
                    xContentBuilder.prettyPrint();
                    xContentBuilder.startObject();
                    indexSettings.toXContent(xContentBuilder, (ToXContent.Params)Settings.FLAT_SETTINGS_TRUE);
                    xContentBuilder.endObject();
                    builder.append(Strings.toString(xContentBuilder));
                }
                builder.append("'");
                builder.append(System.lineSeparator());
                builder.append(separator);
                builder.append(System.lineSeparator());
                logger.warn(builder.toString());
                throw new IllegalArgumentException("node settings must not contain any index level settings");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.clusterSettings.validate(settings, true);
        this.settingsFilter = new SettingsFilter(this.settingsFilterPattern);
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(Settings.class).toInstance(this.settings);
        binder.bind(SettingsFilter.class).toInstance(this.settingsFilter);
        binder.bind(ClusterSettings.class).toInstance(this.clusterSettings);
        binder.bind(IndexScopedSettings.class).toInstance(this.indexScopedSettings);
        binder.bind(ProjectScopedSettings.class).toInstance(this.projectScopedSettings);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerSetting(Setting<?> setting) {
        Setting<?> existingSetting;
        if (!setting.getKey().contains(".") && !SettingsModule.isS3InsecureCredentials(setting)) {
            throw new IllegalArgumentException("setting [" + setting.getKey() + "] is not in any namespace, its name must contain a dot");
        }
        if (setting.isFiltered() && !this.settingsFilterPattern.contains(setting.getKey())) {
            this.registerSettingsFilter(setting.getKey());
        }
        if (!setting.hasNodeScope() && !setting.hasIndexScope()) throw new IllegalArgumentException("No scope found for setting [" + setting.getKey() + "]");
        if (setting.hasNodeScope()) {
            existingSetting = this.nodeSettings.get(setting.getKey());
            if (existingSetting != null) {
                throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
            }
            if (setting.isConsistent()) {
                if (setting instanceof Setting.AffixSetting) {
                    if (!(((Setting.AffixSetting)setting).getConcreteSettingForNamespace("_na_") instanceof SecureSetting)) throw new IllegalArgumentException("Invalid consistent secure setting [" + setting.getKey() + "]");
                    this.consistentSettings.add(setting);
                } else {
                    if (!(setting instanceof SecureSetting)) throw new IllegalArgumentException("Invalid consistent secure setting [" + setting.getKey() + "]");
                    this.consistentSettings.add(setting);
                }
            }
            this.nodeSettings.put(setting.getKey(), setting);
            if (setting.getProperties().contains((Object)Setting.Property.ProjectScope)) {
                this.projectSettings.put(setting.getKey(), setting);
            }
        }
        if (!setting.hasIndexScope()) return;
        if (setting.getProperties().contains((Object)Setting.Property.ProjectScope)) {
            throw new IllegalStateException("setting [" + setting.getKey() + "] cannot be both project and index scoped");
        }
        existingSetting = this.indexSettings.get(setting.getKey());
        if (existingSetting != null) {
            throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
        }
        if (setting.isConsistent()) {
            throw new IllegalStateException("Consistent setting [" + setting.getKey() + "] cannot be index scoped");
        }
        this.indexSettings.put(setting.getKey(), setting);
    }

    private static boolean isS3InsecureCredentials(Setting<?> setting) {
        String settingKey = setting.getKey();
        return settingKey.equals("access_key") || settingKey.equals("secret_key");
    }

    private void registerSettingsFilter(String filter) {
        if (!SettingsFilter.isValidPattern(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] is invalid must be either a key or a regex pattern");
        }
        if (this.settingsFilterPattern.contains(filter)) {
            throw new IllegalArgumentException("filter [" + filter + "] has already been registered");
        }
        this.settingsFilterPattern.add(filter);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }

    public ProjectScopedSettings getProjectScopedSettings() {
        return this.projectScopedSettings;
    }

    public Set<Setting<?>> getConsistentSettings() {
        return this.consistentSettings;
    }

    public SettingsFilter getSettingsFilter() {
        return this.settingsFilter;
    }
}

