/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xpack.core.ml.autoscaling.MlAutoscalingStats;

public class GetMlAutoscalingStats
extends ActionType<Response> {
    public static final GetMlAutoscalingStats INSTANCE = new GetMlAutoscalingStats();
    public static final String NAME = "cluster:monitor/xpack/ml/autoscaling/stats/get";

    public GetMlAutoscalingStats() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final MlAutoscalingStats autoscalingResources;

        public Response(MlAutoscalingStats autoscalingResources) {
            this.autoscalingResources = autoscalingResources;
        }

        public Response(StreamInput in) throws IOException {
            this.autoscalingResources = new MlAutoscalingStats(in);
        }

        public MlAutoscalingStats getAutoscalingResources() {
            return this.autoscalingResources;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.autoscalingResources.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.autoscalingResources);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.autoscalingResources, other.autoscalingResources);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final TimeValue requestTimeout;

        public Request(TimeValue masterNodeTimeout, TimeValue requestTimeout) {
            super(masterNodeTimeout);
            this.requestTimeout = Objects.requireNonNull(requestTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.requestTimeout = in.readTimeValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeTimeValue(this.requestTimeout);
        }

        public TimeValue requestTimeout() {
            return this.requestTimeout;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "get_ml_autoscaling_resources", parentTaskId, headers);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.requestTimeout);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.requestTimeout, other.requestTimeout);
        }
    }
}

