/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.DetectionStatus;
import com.microsoft.graph.models.security.FileDetails;
import com.microsoft.graph.models.security.UserAccount;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProcessEvidence
extends AlertEvidence
implements Parsable {
    public ProcessEvidence() {
        this.setOdataType("#microsoft.graph.security.processEvidence");
    }

    @Nonnull
    public static ProcessEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ProcessEvidence();
    }

    @Nullable
    public DetectionStatus getDetectionStatus() {
        return (DetectionStatus)((Object)this.backingStore.get("detectionStatus"));
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("detectionStatus", n -> this.setDetectionStatus((DetectionStatus)n.getEnumValue(DetectionStatus::forValue)));
        deserializerMap.put("imageFile", n -> this.setImageFile((FileDetails)n.getObjectValue(FileDetails::createFromDiscriminatorValue)));
        deserializerMap.put("mdeDeviceId", n -> this.setMdeDeviceId(n.getStringValue()));
        deserializerMap.put("parentProcessCreationDateTime", n -> this.setParentProcessCreationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("parentProcessId", n -> this.setParentProcessId(n.getLongValue()));
        deserializerMap.put("parentProcessImageFile", n -> this.setParentProcessImageFile((FileDetails)n.getObjectValue(FileDetails::createFromDiscriminatorValue)));
        deserializerMap.put("processCommandLine", n -> this.setProcessCommandLine(n.getStringValue()));
        deserializerMap.put("processCreationDateTime", n -> this.setProcessCreationDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("processId", n -> this.setProcessId(n.getLongValue()));
        deserializerMap.put("userAccount", n -> this.setUserAccount((UserAccount)n.getObjectValue(UserAccount::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public FileDetails getImageFile() {
        return (FileDetails)this.backingStore.get("imageFile");
    }

    @Nullable
    public String getMdeDeviceId() {
        return (String)this.backingStore.get("mdeDeviceId");
    }

    @Nullable
    public OffsetDateTime getParentProcessCreationDateTime() {
        return (OffsetDateTime)this.backingStore.get("parentProcessCreationDateTime");
    }

    @Nullable
    public Long getParentProcessId() {
        return (Long)this.backingStore.get("parentProcessId");
    }

    @Nullable
    public FileDetails getParentProcessImageFile() {
        return (FileDetails)this.backingStore.get("parentProcessImageFile");
    }

    @Nullable
    public String getProcessCommandLine() {
        return (String)this.backingStore.get("processCommandLine");
    }

    @Nullable
    public OffsetDateTime getProcessCreationDateTime() {
        return (OffsetDateTime)this.backingStore.get("processCreationDateTime");
    }

    @Nullable
    public Long getProcessId() {
        return (Long)this.backingStore.get("processId");
    }

    @Nullable
    public UserAccount getUserAccount() {
        return (UserAccount)this.backingStore.get("userAccount");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeEnumValue("detectionStatus", (Enum)this.getDetectionStatus());
        writer.writeObjectValue("imageFile", (Parsable)this.getImageFile(), new Parsable[0]);
        writer.writeStringValue("mdeDeviceId", this.getMdeDeviceId());
        writer.writeOffsetDateTimeValue("parentProcessCreationDateTime", this.getParentProcessCreationDateTime());
        writer.writeLongValue("parentProcessId", this.getParentProcessId());
        writer.writeObjectValue("parentProcessImageFile", (Parsable)this.getParentProcessImageFile(), new Parsable[0]);
        writer.writeStringValue("processCommandLine", this.getProcessCommandLine());
        writer.writeOffsetDateTimeValue("processCreationDateTime", this.getProcessCreationDateTime());
        writer.writeLongValue("processId", this.getProcessId());
        writer.writeObjectValue("userAccount", (Parsable)this.getUserAccount(), new Parsable[0]);
    }

    public void setDetectionStatus(@Nullable DetectionStatus value) {
        this.backingStore.set("detectionStatus", (Object)value);
    }

    public void setImageFile(@Nullable FileDetails value) {
        this.backingStore.set("imageFile", (Object)value);
    }

    public void setMdeDeviceId(@Nullable String value) {
        this.backingStore.set("mdeDeviceId", (Object)value);
    }

    public void setParentProcessCreationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("parentProcessCreationDateTime", (Object)value);
    }

    public void setParentProcessId(@Nullable Long value) {
        this.backingStore.set("parentProcessId", (Object)value);
    }

    public void setParentProcessImageFile(@Nullable FileDetails value) {
        this.backingStore.set("parentProcessImageFile", (Object)value);
    }

    public void setProcessCommandLine(@Nullable String value) {
        this.backingStore.set("processCommandLine", (Object)value);
    }

    public void setProcessCreationDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("processCreationDateTime", (Object)value);
    }

    public void setProcessId(@Nullable Long value) {
        this.backingStore.set("processId", (Object)value);
    }

    public void setUserAccount(@Nullable UserAccount value) {
        this.backingStore.set("userAccount", (Object)value);
    }
}

