/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DeviceCompliancePolicy;
import com.microsoft.graph.models.RequiredPasswordType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsPhone81CompliancePolicy
extends DeviceCompliancePolicy
implements Parsable {
    public WindowsPhone81CompliancePolicy() {
        this.setOdataType("#microsoft.graph.windowsPhone81CompliancePolicy");
    }

    @Nonnull
    public static WindowsPhone81CompliancePolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsPhone81CompliancePolicy();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("osMaximumVersion", n -> this.setOsMaximumVersion(n.getStringValue()));
        deserializerMap.put("osMinimumVersion", n -> this.setOsMinimumVersion(n.getStringValue()));
        deserializerMap.put("passwordBlockSimple", n -> this.setPasswordBlockSimple(n.getBooleanValue()));
        deserializerMap.put("passwordExpirationDays", n -> this.setPasswordExpirationDays(n.getIntegerValue()));
        deserializerMap.put("passwordMinimumCharacterSetCount", n -> this.setPasswordMinimumCharacterSetCount(n.getIntegerValue()));
        deserializerMap.put("passwordMinimumLength", n -> this.setPasswordMinimumLength(n.getIntegerValue()));
        deserializerMap.put("passwordMinutesOfInactivityBeforeLock", n -> this.setPasswordMinutesOfInactivityBeforeLock(n.getIntegerValue()));
        deserializerMap.put("passwordPreviousPasswordBlockCount", n -> this.setPasswordPreviousPasswordBlockCount(n.getIntegerValue()));
        deserializerMap.put("passwordRequired", n -> this.setPasswordRequired(n.getBooleanValue()));
        deserializerMap.put("passwordRequiredType", n -> this.setPasswordRequiredType((RequiredPasswordType)n.getEnumValue(RequiredPasswordType::forValue)));
        deserializerMap.put("storageRequireEncryption", n -> this.setStorageRequireEncryption(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOsMaximumVersion() {
        return (String)this.backingStore.get("osMaximumVersion");
    }

    @Nullable
    public String getOsMinimumVersion() {
        return (String)this.backingStore.get("osMinimumVersion");
    }

    @Nullable
    public Boolean getPasswordBlockSimple() {
        return (Boolean)this.backingStore.get("passwordBlockSimple");
    }

    @Nullable
    public Integer getPasswordExpirationDays() {
        return (Integer)this.backingStore.get("passwordExpirationDays");
    }

    @Nullable
    public Integer getPasswordMinimumCharacterSetCount() {
        return (Integer)this.backingStore.get("passwordMinimumCharacterSetCount");
    }

    @Nullable
    public Integer getPasswordMinimumLength() {
        return (Integer)this.backingStore.get("passwordMinimumLength");
    }

    @Nullable
    public Integer getPasswordMinutesOfInactivityBeforeLock() {
        return (Integer)this.backingStore.get("passwordMinutesOfInactivityBeforeLock");
    }

    @Nullable
    public Integer getPasswordPreviousPasswordBlockCount() {
        return (Integer)this.backingStore.get("passwordPreviousPasswordBlockCount");
    }

    @Nullable
    public Boolean getPasswordRequired() {
        return (Boolean)this.backingStore.get("passwordRequired");
    }

    @Nullable
    public RequiredPasswordType getPasswordRequiredType() {
        return (RequiredPasswordType)((Object)this.backingStore.get("passwordRequiredType"));
    }

    @Nullable
    public Boolean getStorageRequireEncryption() {
        return (Boolean)this.backingStore.get("storageRequireEncryption");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("osMaximumVersion", this.getOsMaximumVersion());
        writer.writeStringValue("osMinimumVersion", this.getOsMinimumVersion());
        writer.writeBooleanValue("passwordBlockSimple", this.getPasswordBlockSimple());
        writer.writeIntegerValue("passwordExpirationDays", this.getPasswordExpirationDays());
        writer.writeIntegerValue("passwordMinimumCharacterSetCount", this.getPasswordMinimumCharacterSetCount());
        writer.writeIntegerValue("passwordMinimumLength", this.getPasswordMinimumLength());
        writer.writeIntegerValue("passwordMinutesOfInactivityBeforeLock", this.getPasswordMinutesOfInactivityBeforeLock());
        writer.writeIntegerValue("passwordPreviousPasswordBlockCount", this.getPasswordPreviousPasswordBlockCount());
        writer.writeBooleanValue("passwordRequired", this.getPasswordRequired());
        writer.writeEnumValue("passwordRequiredType", (Enum)this.getPasswordRequiredType());
        writer.writeBooleanValue("storageRequireEncryption", this.getStorageRequireEncryption());
    }

    public void setOsMaximumVersion(@Nullable String value) {
        this.backingStore.set("osMaximumVersion", (Object)value);
    }

    public void setOsMinimumVersion(@Nullable String value) {
        this.backingStore.set("osMinimumVersion", (Object)value);
    }

    public void setPasswordBlockSimple(@Nullable Boolean value) {
        this.backingStore.set("passwordBlockSimple", (Object)value);
    }

    public void setPasswordExpirationDays(@Nullable Integer value) {
        this.backingStore.set("passwordExpirationDays", (Object)value);
    }

    public void setPasswordMinimumCharacterSetCount(@Nullable Integer value) {
        this.backingStore.set("passwordMinimumCharacterSetCount", (Object)value);
    }

    public void setPasswordMinimumLength(@Nullable Integer value) {
        this.backingStore.set("passwordMinimumLength", (Object)value);
    }

    public void setPasswordMinutesOfInactivityBeforeLock(@Nullable Integer value) {
        this.backingStore.set("passwordMinutesOfInactivityBeforeLock", (Object)value);
    }

    public void setPasswordPreviousPasswordBlockCount(@Nullable Integer value) {
        this.backingStore.set("passwordPreviousPasswordBlockCount", (Object)value);
    }

    public void setPasswordRequired(@Nullable Boolean value) {
        this.backingStore.set("passwordRequired", (Object)value);
    }

    public void setPasswordRequiredType(@Nullable RequiredPasswordType value) {
        this.backingStore.set("passwordRequiredType", (Object)value);
    }

    public void setStorageRequireEncryption(@Nullable Boolean value) {
        this.backingStore.set("storageRequireEncryption", (Object)value);
    }
}

