/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AssociatedTeamInfo;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.SharedWithChannelTeamInfo;
import com.microsoft.graph.models.Team;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TeamInfo
extends Entity
implements Parsable {
    @Nonnull
    public static TeamInfo createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.associatedTeamInfo": {
                    return new AssociatedTeamInfo();
                }
                case "#microsoft.graph.sharedWithChannelTeamInfo": {
                    return new SharedWithChannelTeamInfo();
                }
            }
        }
        return new TeamInfo();
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("team", n -> this.setTeam((Team)n.getObjectValue(Team::createFromDiscriminatorValue)));
        deserializerMap.put("tenantId", n -> this.setTenantId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Team getTeam() {
        return (Team)this.backingStore.get("team");
    }

    @Nullable
    public String getTenantId() {
        return (String)this.backingStore.get("tenantId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeObjectValue("team", (Parsable)this.getTeam(), new Parsable[0]);
        writer.writeStringValue("tenantId", this.getTenantId());
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setTeam(@Nullable Team value) {
        this.backingStore.set("team", (Object)value);
    }

    public void setTenantId(@Nullable String value) {
        this.backingStore.set("tenantId", (Object)value);
    }
}

