/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteEntityHierarchyModel;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SectionGroup
extends OnenoteEntityHierarchyModel
implements Parsable {
    public SectionGroup() {
        this.setOdataType("#microsoft.graph.sectionGroup");
    }

    @Nonnull
    public static SectionGroup createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SectionGroup();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("parentNotebook", n -> this.setParentNotebook((Notebook)n.getObjectValue(Notebook::createFromDiscriminatorValue)));
        deserializerMap.put("parentSectionGroup", n -> this.setParentSectionGroup((SectionGroup)n.getObjectValue(SectionGroup::createFromDiscriminatorValue)));
        deserializerMap.put("sectionGroups", n -> this.setSectionGroups(n.getCollectionOfObjectValues(SectionGroup::createFromDiscriminatorValue)));
        deserializerMap.put("sectionGroupsUrl", n -> this.setSectionGroupsUrl(n.getStringValue()));
        deserializerMap.put("sections", n -> this.setSections(n.getCollectionOfObjectValues(OnenoteSection::createFromDiscriminatorValue)));
        deserializerMap.put("sectionsUrl", n -> this.setSectionsUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Notebook getParentNotebook() {
        return (Notebook)this.backingStore.get("parentNotebook");
    }

    @Nullable
    public SectionGroup getParentSectionGroup() {
        return (SectionGroup)this.backingStore.get("parentSectionGroup");
    }

    @Nullable
    public List<SectionGroup> getSectionGroups() {
        return (List)this.backingStore.get("sectionGroups");
    }

    @Nullable
    public String getSectionGroupsUrl() {
        return (String)this.backingStore.get("sectionGroupsUrl");
    }

    @Nullable
    public List<OnenoteSection> getSections() {
        return (List)this.backingStore.get("sections");
    }

    @Nullable
    public String getSectionsUrl() {
        return (String)this.backingStore.get("sectionsUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("parentNotebook", (Parsable)this.getParentNotebook(), new Parsable[0]);
        writer.writeObjectValue("parentSectionGroup", (Parsable)this.getParentSectionGroup(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("sectionGroups", this.getSectionGroups());
        writer.writeStringValue("sectionGroupsUrl", this.getSectionGroupsUrl());
        writer.writeCollectionOfObjectValues("sections", this.getSections());
        writer.writeStringValue("sectionsUrl", this.getSectionsUrl());
    }

    public void setParentNotebook(@Nullable Notebook value) {
        this.backingStore.set("parentNotebook", (Object)value);
    }

    public void setParentSectionGroup(@Nullable SectionGroup value) {
        this.backingStore.set("parentSectionGroup", (Object)value);
    }

    public void setSectionGroups(@Nullable List<SectionGroup> value) {
        this.backingStore.set("sectionGroups", value);
    }

    public void setSectionGroupsUrl(@Nullable String value) {
        this.backingStore.set("sectionGroupsUrl", (Object)value);
    }

    public void setSections(@Nullable List<OnenoteSection> value) {
        this.backingStore.set("sections", value);
    }

    public void setSectionsUrl(@Nullable String value) {
        this.backingStore.set("sectionsUrl", (Object)value);
    }
}

