/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AlterationResponse;
import com.microsoft.graph.models.ResultTemplateDictionary;
import com.microsoft.graph.models.SearchHitsContainer;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SearchResponse
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public SearchResponse() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static SearchResponse createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SearchResponse();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("hitsContainers", n -> this.setHitsContainers(n.getCollectionOfObjectValues(SearchHitsContainer::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("queryAlterationResponse", n -> this.setQueryAlterationResponse((AlterationResponse)n.getObjectValue(AlterationResponse::createFromDiscriminatorValue)));
        deserializerMap.put("resultTemplates", n -> this.setResultTemplates((ResultTemplateDictionary)n.getObjectValue(ResultTemplateDictionary::createFromDiscriminatorValue)));
        deserializerMap.put("searchTerms", n -> this.setSearchTerms(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public List<SearchHitsContainer> getHitsContainers() {
        return (List)this.backingStore.get("hitsContainers");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public AlterationResponse getQueryAlterationResponse() {
        return (AlterationResponse)this.backingStore.get("queryAlterationResponse");
    }

    @Nullable
    public ResultTemplateDictionary getResultTemplates() {
        return (ResultTemplateDictionary)this.backingStore.get("resultTemplates");
    }

    @Nullable
    public List<String> getSearchTerms() {
        return (List)this.backingStore.get("searchTerms");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("hitsContainers", this.getHitsContainers());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("queryAlterationResponse", (Parsable)this.getQueryAlterationResponse(), new Parsable[0]);
        writer.writeObjectValue("resultTemplates", (Parsable)this.getResultTemplates(), new Parsable[0]);
        writer.writeCollectionOfPrimitiveValues("searchTerms", this.getSearchTerms());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setHitsContainers(@Nullable List<SearchHitsContainer> value) {
        this.backingStore.set("hitsContainers", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setQueryAlterationResponse(@Nullable AlterationResponse value) {
        this.backingStore.set("queryAlterationResponse", (Object)value);
    }

    public void setResultTemplates(@Nullable ResultTemplateDictionary value) {
        this.backingStore.set("resultTemplates", (Object)value);
    }

    public void setSearchTerms(@Nullable List<String> value) {
        this.backingStore.set("searchTerms", value);
    }
}

