/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingType;
import com.microsoft.graph.models.Place;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Room
extends Place
implements Parsable {
    public Room() {
        this.setOdataType("#microsoft.graph.room");
    }

    @Nonnull
    public static Room createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Room();
    }

    @Nullable
    public String getAudioDeviceName() {
        return (String)this.backingStore.get("audioDeviceName");
    }

    @Nullable
    public BookingType getBookingType() {
        return (BookingType)((Object)this.backingStore.get("bookingType"));
    }

    @Nullable
    public String getBuilding() {
        return (String)this.backingStore.get("building");
    }

    @Nullable
    public Integer getCapacity() {
        return (Integer)this.backingStore.get("capacity");
    }

    @Nullable
    public String getDisplayDeviceName() {
        return (String)this.backingStore.get("displayDeviceName");
    }

    @Nullable
    public String getEmailAddress() {
        return (String)this.backingStore.get("emailAddress");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("audioDeviceName", n -> this.setAudioDeviceName(n.getStringValue()));
        deserializerMap.put("bookingType", n -> this.setBookingType((BookingType)n.getEnumValue(BookingType::forValue)));
        deserializerMap.put("building", n -> this.setBuilding(n.getStringValue()));
        deserializerMap.put("capacity", n -> this.setCapacity(n.getIntegerValue()));
        deserializerMap.put("displayDeviceName", n -> this.setDisplayDeviceName(n.getStringValue()));
        deserializerMap.put("emailAddress", n -> this.setEmailAddress(n.getStringValue()));
        deserializerMap.put("floorLabel", n -> this.setFloorLabel(n.getStringValue()));
        deserializerMap.put("floorNumber", n -> this.setFloorNumber(n.getIntegerValue()));
        deserializerMap.put("isWheelChairAccessible", n -> this.setIsWheelChairAccessible(n.getBooleanValue()));
        deserializerMap.put("label", n -> this.setLabel(n.getStringValue()));
        deserializerMap.put("nickname", n -> this.setNickname(n.getStringValue()));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("videoDeviceName", n -> this.setVideoDeviceName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getFloorLabel() {
        return (String)this.backingStore.get("floorLabel");
    }

    @Nullable
    public Integer getFloorNumber() {
        return (Integer)this.backingStore.get("floorNumber");
    }

    @Nullable
    public Boolean getIsWheelChairAccessible() {
        return (Boolean)this.backingStore.get("isWheelChairAccessible");
    }

    @Nullable
    public String getLabel() {
        return (String)this.backingStore.get("label");
    }

    @Nullable
    public String getNickname() {
        return (String)this.backingStore.get("nickname");
    }

    @Nullable
    public List<String> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Nullable
    public String getVideoDeviceName() {
        return (String)this.backingStore.get("videoDeviceName");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("audioDeviceName", this.getAudioDeviceName());
        writer.writeEnumValue("bookingType", (Enum)this.getBookingType());
        writer.writeStringValue("building", this.getBuilding());
        writer.writeIntegerValue("capacity", this.getCapacity());
        writer.writeStringValue("displayDeviceName", this.getDisplayDeviceName());
        writer.writeStringValue("emailAddress", this.getEmailAddress());
        writer.writeStringValue("floorLabel", this.getFloorLabel());
        writer.writeIntegerValue("floorNumber", this.getFloorNumber());
        writer.writeBooleanValue("isWheelChairAccessible", this.getIsWheelChairAccessible());
        writer.writeStringValue("label", this.getLabel());
        writer.writeStringValue("nickname", this.getNickname());
        writer.writeCollectionOfPrimitiveValues("tags", this.getTags());
        writer.writeStringValue("videoDeviceName", this.getVideoDeviceName());
    }

    public void setAudioDeviceName(@Nullable String value) {
        this.backingStore.set("audioDeviceName", (Object)value);
    }

    public void setBookingType(@Nullable BookingType value) {
        this.backingStore.set("bookingType", (Object)value);
    }

    public void setBuilding(@Nullable String value) {
        this.backingStore.set("building", (Object)value);
    }

    public void setCapacity(@Nullable Integer value) {
        this.backingStore.set("capacity", (Object)value);
    }

    public void setDisplayDeviceName(@Nullable String value) {
        this.backingStore.set("displayDeviceName", (Object)value);
    }

    public void setEmailAddress(@Nullable String value) {
        this.backingStore.set("emailAddress", (Object)value);
    }

    public void setFloorLabel(@Nullable String value) {
        this.backingStore.set("floorLabel", (Object)value);
    }

    public void setFloorNumber(@Nullable Integer value) {
        this.backingStore.set("floorNumber", (Object)value);
    }

    public void setIsWheelChairAccessible(@Nullable Boolean value) {
        this.backingStore.set("isWheelChairAccessible", (Object)value);
    }

    public void setLabel(@Nullable String value) {
        this.backingStore.set("label", (Object)value);
    }

    public void setNickname(@Nullable String value) {
        this.backingStore.set("nickname", (Object)value);
    }

    public void setTags(@Nullable List<String> value) {
        this.backingStore.set("tags", value);
    }

    public void setVideoDeviceName(@Nullable String value) {
        this.backingStore.set("videoDeviceName", (Object)value);
    }
}

