/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DetailsInfo;
import com.microsoft.graph.models.ProvisioningResult;
import com.microsoft.graph.models.ProvisioningStepType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ProvisioningStep
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ProvisioningStep() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ProvisioningStep createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ProvisioningStep();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public DetailsInfo getDetails() {
        return (DetailsInfo)this.backingStore.get("details");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("details", n -> this.setDetails((DetailsInfo)n.getObjectValue(DetailsInfo::createFromDiscriminatorValue)));
        deserializerMap.put("name", n -> this.setName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("provisioningStepType", n -> this.setProvisioningStepType((ProvisioningStepType)n.getEnumValue(ProvisioningStepType::forValue)));
        deserializerMap.put("status", n -> this.setStatus((ProvisioningResult)n.getEnumValue(ProvisioningResult::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getName() {
        return (String)this.backingStore.get("name");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ProvisioningStepType getProvisioningStepType() {
        return (ProvisioningStepType)((Object)this.backingStore.get("provisioningStepType"));
    }

    @Nullable
    public ProvisioningResult getStatus() {
        return (ProvisioningResult)((Object)this.backingStore.get("status"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("description", this.getDescription());
        writer.writeObjectValue("details", (Parsable)this.getDetails(), new Parsable[0]);
        writer.writeStringValue("name", this.getName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("provisioningStepType", (Enum)this.getProvisioningStepType());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDetails(@Nullable DetailsInfo value) {
        this.backingStore.set("details", (Object)value);
    }

    public void setName(@Nullable String value) {
        this.backingStore.set("name", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProvisioningStepType(@Nullable ProvisioningStepType value) {
        this.backingStore.set("provisioningStepType", (Object)value);
    }

    public void setStatus(@Nullable ProvisioningResult value) {
        this.backingStore.set("status", (Object)value);
    }
}

