/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ConnectionDirection;
import com.microsoft.graph.models.ConnectionStatus;
import com.microsoft.graph.models.SecurityNetworkProtocol;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NetworkConnection
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public NetworkConnection() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static NetworkConnection createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new NetworkConnection();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getApplicationName() {
        return (String)this.backingStore.get("applicationName");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getDestinationAddress() {
        return (String)this.backingStore.get("destinationAddress");
    }

    @Nullable
    public String getDestinationDomain() {
        return (String)this.backingStore.get("destinationDomain");
    }

    @Nullable
    public String getDestinationLocation() {
        return (String)this.backingStore.get("destinationLocation");
    }

    @Nullable
    public String getDestinationPort() {
        return (String)this.backingStore.get("destinationPort");
    }

    @Nullable
    public String getDestinationUrl() {
        return (String)this.backingStore.get("destinationUrl");
    }

    @Nullable
    public ConnectionDirection getDirection() {
        return (ConnectionDirection)((Object)this.backingStore.get("direction"));
    }

    @Nullable
    public OffsetDateTime getDomainRegisteredDateTime() {
        return (OffsetDateTime)this.backingStore.get("domainRegisteredDateTime");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(21);
        deserializerMap.put("applicationName", n -> this.setApplicationName(n.getStringValue()));
        deserializerMap.put("destinationAddress", n -> this.setDestinationAddress(n.getStringValue()));
        deserializerMap.put("destinationDomain", n -> this.setDestinationDomain(n.getStringValue()));
        deserializerMap.put("destinationLocation", n -> this.setDestinationLocation(n.getStringValue()));
        deserializerMap.put("destinationPort", n -> this.setDestinationPort(n.getStringValue()));
        deserializerMap.put("destinationUrl", n -> this.setDestinationUrl(n.getStringValue()));
        deserializerMap.put("direction", n -> this.setDirection((ConnectionDirection)n.getEnumValue(ConnectionDirection::forValue)));
        deserializerMap.put("domainRegisteredDateTime", n -> this.setDomainRegisteredDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("localDnsName", n -> this.setLocalDnsName(n.getStringValue()));
        deserializerMap.put("natDestinationAddress", n -> this.setNatDestinationAddress(n.getStringValue()));
        deserializerMap.put("natDestinationPort", n -> this.setNatDestinationPort(n.getStringValue()));
        deserializerMap.put("natSourceAddress", n -> this.setNatSourceAddress(n.getStringValue()));
        deserializerMap.put("natSourcePort", n -> this.setNatSourcePort(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("protocol", n -> this.setProtocol((SecurityNetworkProtocol)n.getEnumValue(SecurityNetworkProtocol::forValue)));
        deserializerMap.put("riskScore", n -> this.setRiskScore(n.getStringValue()));
        deserializerMap.put("sourceAddress", n -> this.setSourceAddress(n.getStringValue()));
        deserializerMap.put("sourceLocation", n -> this.setSourceLocation(n.getStringValue()));
        deserializerMap.put("sourcePort", n -> this.setSourcePort(n.getStringValue()));
        deserializerMap.put("status", n -> this.setStatus((ConnectionStatus)n.getEnumValue(ConnectionStatus::forValue)));
        deserializerMap.put("urlParameters", n -> this.setUrlParameters(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getLocalDnsName() {
        return (String)this.backingStore.get("localDnsName");
    }

    @Nullable
    public String getNatDestinationAddress() {
        return (String)this.backingStore.get("natDestinationAddress");
    }

    @Nullable
    public String getNatDestinationPort() {
        return (String)this.backingStore.get("natDestinationPort");
    }

    @Nullable
    public String getNatSourceAddress() {
        return (String)this.backingStore.get("natSourceAddress");
    }

    @Nullable
    public String getNatSourcePort() {
        return (String)this.backingStore.get("natSourcePort");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public SecurityNetworkProtocol getProtocol() {
        return (SecurityNetworkProtocol)((Object)this.backingStore.get("protocol"));
    }

    @Nullable
    public String getRiskScore() {
        return (String)this.backingStore.get("riskScore");
    }

    @Nullable
    public String getSourceAddress() {
        return (String)this.backingStore.get("sourceAddress");
    }

    @Nullable
    public String getSourceLocation() {
        return (String)this.backingStore.get("sourceLocation");
    }

    @Nullable
    public String getSourcePort() {
        return (String)this.backingStore.get("sourcePort");
    }

    @Nullable
    public ConnectionStatus getStatus() {
        return (ConnectionStatus)((Object)this.backingStore.get("status"));
    }

    @Nullable
    public String getUrlParameters() {
        return (String)this.backingStore.get("urlParameters");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("applicationName", this.getApplicationName());
        writer.writeStringValue("destinationAddress", this.getDestinationAddress());
        writer.writeStringValue("destinationDomain", this.getDestinationDomain());
        writer.writeStringValue("destinationLocation", this.getDestinationLocation());
        writer.writeStringValue("destinationPort", this.getDestinationPort());
        writer.writeStringValue("destinationUrl", this.getDestinationUrl());
        writer.writeEnumValue("direction", (Enum)this.getDirection());
        writer.writeOffsetDateTimeValue("domainRegisteredDateTime", this.getDomainRegisteredDateTime());
        writer.writeStringValue("localDnsName", this.getLocalDnsName());
        writer.writeStringValue("natDestinationAddress", this.getNatDestinationAddress());
        writer.writeStringValue("natDestinationPort", this.getNatDestinationPort());
        writer.writeStringValue("natSourceAddress", this.getNatSourceAddress());
        writer.writeStringValue("natSourcePort", this.getNatSourcePort());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("protocol", (Enum)this.getProtocol());
        writer.writeStringValue("riskScore", this.getRiskScore());
        writer.writeStringValue("sourceAddress", this.getSourceAddress());
        writer.writeStringValue("sourceLocation", this.getSourceLocation());
        writer.writeStringValue("sourcePort", this.getSourcePort());
        writer.writeEnumValue("status", (Enum)this.getStatus());
        writer.writeStringValue("urlParameters", this.getUrlParameters());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplicationName(@Nullable String value) {
        this.backingStore.set("applicationName", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setDestinationAddress(@Nullable String value) {
        this.backingStore.set("destinationAddress", (Object)value);
    }

    public void setDestinationDomain(@Nullable String value) {
        this.backingStore.set("destinationDomain", (Object)value);
    }

    public void setDestinationLocation(@Nullable String value) {
        this.backingStore.set("destinationLocation", (Object)value);
    }

    public void setDestinationPort(@Nullable String value) {
        this.backingStore.set("destinationPort", (Object)value);
    }

    public void setDestinationUrl(@Nullable String value) {
        this.backingStore.set("destinationUrl", (Object)value);
    }

    public void setDirection(@Nullable ConnectionDirection value) {
        this.backingStore.set("direction", (Object)value);
    }

    public void setDomainRegisteredDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("domainRegisteredDateTime", (Object)value);
    }

    public void setLocalDnsName(@Nullable String value) {
        this.backingStore.set("localDnsName", (Object)value);
    }

    public void setNatDestinationAddress(@Nullable String value) {
        this.backingStore.set("natDestinationAddress", (Object)value);
    }

    public void setNatDestinationPort(@Nullable String value) {
        this.backingStore.set("natDestinationPort", (Object)value);
    }

    public void setNatSourceAddress(@Nullable String value) {
        this.backingStore.set("natSourceAddress", (Object)value);
    }

    public void setNatSourcePort(@Nullable String value) {
        this.backingStore.set("natSourcePort", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setProtocol(@Nullable SecurityNetworkProtocol value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setRiskScore(@Nullable String value) {
        this.backingStore.set("riskScore", (Object)value);
    }

    public void setSourceAddress(@Nullable String value) {
        this.backingStore.set("sourceAddress", (Object)value);
    }

    public void setSourceLocation(@Nullable String value) {
        this.backingStore.set("sourceLocation", (Object)value);
    }

    public void setSourcePort(@Nullable String value) {
        this.backingStore.set("sourcePort", (Object)value);
    }

    public void setStatus(@Nullable ConnectionStatus value) {
        this.backingStore.set("status", (Object)value);
    }

    public void setUrlParameters(@Nullable String value) {
        this.backingStore.set("urlParameters", (Object)value);
    }
}

