/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.Recipient;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class MessageRuleActions
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public MessageRuleActions() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static MessageRuleActions createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new MessageRuleActions();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public List<String> getAssignCategories() {
        return (List)this.backingStore.get("assignCategories");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCopyToFolder() {
        return (String)this.backingStore.get("copyToFolder");
    }

    @Nullable
    public Boolean getDelete() {
        return (Boolean)this.backingStore.get("delete");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(12);
        deserializerMap.put("assignCategories", n -> this.setAssignCategories(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("copyToFolder", n -> this.setCopyToFolder(n.getStringValue()));
        deserializerMap.put("delete", n -> this.setDelete(n.getBooleanValue()));
        deserializerMap.put("forwardAsAttachmentTo", n -> this.setForwardAsAttachmentTo(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("forwardTo", n -> this.setForwardTo(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("markAsRead", n -> this.setMarkAsRead(n.getBooleanValue()));
        deserializerMap.put("markImportance", n -> this.setMarkImportance((Importance)n.getEnumValue(Importance::forValue)));
        deserializerMap.put("moveToFolder", n -> this.setMoveToFolder(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("permanentDelete", n -> this.setPermanentDelete(n.getBooleanValue()));
        deserializerMap.put("redirectTo", n -> this.setRedirectTo(n.getCollectionOfObjectValues(Recipient::createFromDiscriminatorValue)));
        deserializerMap.put("stopProcessingRules", n -> this.setStopProcessingRules(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public List<Recipient> getForwardAsAttachmentTo() {
        return (List)this.backingStore.get("forwardAsAttachmentTo");
    }

    @Nullable
    public List<Recipient> getForwardTo() {
        return (List)this.backingStore.get("forwardTo");
    }

    @Nullable
    public Boolean getMarkAsRead() {
        return (Boolean)this.backingStore.get("markAsRead");
    }

    @Nullable
    public Importance getMarkImportance() {
        return (Importance)((Object)this.backingStore.get("markImportance"));
    }

    @Nullable
    public String getMoveToFolder() {
        return (String)this.backingStore.get("moveToFolder");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Boolean getPermanentDelete() {
        return (Boolean)this.backingStore.get("permanentDelete");
    }

    @Nullable
    public List<Recipient> getRedirectTo() {
        return (List)this.backingStore.get("redirectTo");
    }

    @Nullable
    public Boolean getStopProcessingRules() {
        return (Boolean)this.backingStore.get("stopProcessingRules");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfPrimitiveValues("assignCategories", this.getAssignCategories());
        writer.writeStringValue("copyToFolder", this.getCopyToFolder());
        writer.writeBooleanValue("delete", this.getDelete());
        writer.writeCollectionOfObjectValues("forwardAsAttachmentTo", this.getForwardAsAttachmentTo());
        writer.writeCollectionOfObjectValues("forwardTo", this.getForwardTo());
        writer.writeBooleanValue("markAsRead", this.getMarkAsRead());
        writer.writeEnumValue("markImportance", (Enum)this.getMarkImportance());
        writer.writeStringValue("moveToFolder", this.getMoveToFolder());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeBooleanValue("permanentDelete", this.getPermanentDelete());
        writer.writeCollectionOfObjectValues("redirectTo", this.getRedirectTo());
        writer.writeBooleanValue("stopProcessingRules", this.getStopProcessingRules());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAssignCategories(@Nullable List<String> value) {
        this.backingStore.set("assignCategories", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCopyToFolder(@Nullable String value) {
        this.backingStore.set("copyToFolder", (Object)value);
    }

    public void setDelete(@Nullable Boolean value) {
        this.backingStore.set("delete", (Object)value);
    }

    public void setForwardAsAttachmentTo(@Nullable List<Recipient> value) {
        this.backingStore.set("forwardAsAttachmentTo", value);
    }

    public void setForwardTo(@Nullable List<Recipient> value) {
        this.backingStore.set("forwardTo", value);
    }

    public void setMarkAsRead(@Nullable Boolean value) {
        this.backingStore.set("markAsRead", (Object)value);
    }

    public void setMarkImportance(@Nullable Importance value) {
        this.backingStore.set("markImportance", (Object)value);
    }

    public void setMoveToFolder(@Nullable String value) {
        this.backingStore.set("moveToFolder", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPermanentDelete(@Nullable Boolean value) {
        this.backingStore.set("permanentDelete", (Object)value);
    }

    public void setRedirectTo(@Nullable List<Recipient> value) {
        this.backingStore.set("redirectTo", value);
    }

    public void setStopProcessingRules(@Nullable Boolean value) {
        this.backingStore.set("stopProcessingRules", (Object)value);
    }
}

