/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.DayOfWeek;
import com.microsoft.graph.models.DeviceConfiguration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class IosUpdateConfiguration
extends DeviceConfiguration
implements Parsable {
    public IosUpdateConfiguration() {
        this.setOdataType("#microsoft.graph.iosUpdateConfiguration");
    }

    @Nonnull
    public static IosUpdateConfiguration createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new IosUpdateConfiguration();
    }

    @Nullable
    public LocalTime getActiveHoursEnd() {
        return (LocalTime)this.backingStore.get("activeHoursEnd");
    }

    @Nullable
    public LocalTime getActiveHoursStart() {
        return (LocalTime)this.backingStore.get("activeHoursStart");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activeHoursEnd", n -> this.setActiveHoursEnd(n.getLocalTimeValue()));
        deserializerMap.put("activeHoursStart", n -> this.setActiveHoursStart(n.getLocalTimeValue()));
        deserializerMap.put("scheduledInstallDays", n -> this.setScheduledInstallDays(n.getCollectionOfEnumValues(DayOfWeek::forValue)));
        deserializerMap.put("utcTimeOffsetInMinutes", n -> this.setUtcTimeOffsetInMinutes(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public List<DayOfWeek> getScheduledInstallDays() {
        return (List)this.backingStore.get("scheduledInstallDays");
    }

    @Nullable
    public Integer getUtcTimeOffsetInMinutes() {
        return (Integer)this.backingStore.get("utcTimeOffsetInMinutes");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeLocalTimeValue("activeHoursEnd", this.getActiveHoursEnd());
        writer.writeLocalTimeValue("activeHoursStart", this.getActiveHoursStart());
        writer.writeCollectionOfEnumValues("scheduledInstallDays", this.getScheduledInstallDays());
        writer.writeIntegerValue("utcTimeOffsetInMinutes", this.getUtcTimeOffsetInMinutes());
    }

    public void setActiveHoursEnd(@Nullable LocalTime value) {
        this.backingStore.set("activeHoursEnd", (Object)value);
    }

    public void setActiveHoursStart(@Nullable LocalTime value) {
        this.backingStore.set("activeHoursStart", (Object)value);
    }

    public void setScheduledInstallDays(@Nullable List<DayOfWeek> value) {
        this.backingStore.set("scheduledInstallDays", value);
    }

    public void setUtcTimeOffsetInMinutes(@Nullable Integer value) {
        this.backingStore.set("utcTimeOffsetInMinutes", (Object)value);
    }
}

