/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceDetail
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceDetail() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceDetail createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceDetail();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getBrowser() {
        return (String)this.backingStore.get("browser");
    }

    @Nullable
    public String getDeviceId() {
        return (String)this.backingStore.get("deviceId");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(8);
        deserializerMap.put("browser", n -> this.setBrowser(n.getStringValue()));
        deserializerMap.put("deviceId", n -> this.setDeviceId(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("isCompliant", n -> this.setIsCompliant(n.getBooleanValue()));
        deserializerMap.put("isManaged", n -> this.setIsManaged(n.getBooleanValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operatingSystem", n -> this.setOperatingSystem(n.getStringValue()));
        deserializerMap.put("trustType", n -> this.setTrustType(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsCompliant() {
        return (Boolean)this.backingStore.get("isCompliant");
    }

    @Nullable
    public Boolean getIsManaged() {
        return (Boolean)this.backingStore.get("isManaged");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.backingStore.get("operatingSystem");
    }

    @Nullable
    public String getTrustType() {
        return (String)this.backingStore.get("trustType");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("browser", this.getBrowser());
        writer.writeStringValue("deviceId", this.getDeviceId());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeBooleanValue("isCompliant", this.getIsCompliant());
        writer.writeBooleanValue("isManaged", this.getIsManaged());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("operatingSystem", this.getOperatingSystem());
        writer.writeStringValue("trustType", this.getTrustType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setBrowser(@Nullable String value) {
        this.backingStore.set("browser", (Object)value);
    }

    public void setDeviceId(@Nullable String value) {
        this.backingStore.set("deviceId", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setIsCompliant(@Nullable Boolean value) {
        this.backingStore.set("isCompliant", (Object)value);
    }

    public void setIsManaged(@Nullable Boolean value) {
        this.backingStore.set("isManaged", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.backingStore.set("operatingSystem", (Object)value);
    }

    public void setTrustType(@Nullable String value) {
        this.backingStore.set("trustType", (Object)value);
    }
}

