/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AndroidCompliancePolicy;
import com.microsoft.graph.models.AndroidWorkProfileCompliancePolicy;
import com.microsoft.graph.models.DeviceComplianceDeviceOverview;
import com.microsoft.graph.models.DeviceComplianceDeviceStatus;
import com.microsoft.graph.models.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.DeviceComplianceScheduledActionForRule;
import com.microsoft.graph.models.DeviceComplianceUserOverview;
import com.microsoft.graph.models.DeviceComplianceUserStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.IosCompliancePolicy;
import com.microsoft.graph.models.MacOSCompliancePolicy;
import com.microsoft.graph.models.SettingStateDeviceSummary;
import com.microsoft.graph.models.Windows10CompliancePolicy;
import com.microsoft.graph.models.Windows10MobileCompliancePolicy;
import com.microsoft.graph.models.Windows81CompliancePolicy;
import com.microsoft.graph.models.WindowsPhone81CompliancePolicy;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceCompliancePolicy
extends Entity
implements Parsable {
    @Nonnull
    public static DeviceCompliancePolicy createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.androidCompliancePolicy": {
                    return new AndroidCompliancePolicy();
                }
                case "#microsoft.graph.androidWorkProfileCompliancePolicy": {
                    return new AndroidWorkProfileCompliancePolicy();
                }
                case "#microsoft.graph.iosCompliancePolicy": {
                    return new IosCompliancePolicy();
                }
                case "#microsoft.graph.macOSCompliancePolicy": {
                    return new MacOSCompliancePolicy();
                }
                case "#microsoft.graph.windows10CompliancePolicy": {
                    return new Windows10CompliancePolicy();
                }
                case "#microsoft.graph.windows10MobileCompliancePolicy": {
                    return new Windows10MobileCompliancePolicy();
                }
                case "#microsoft.graph.windows81CompliancePolicy": {
                    return new Windows81CompliancePolicy();
                }
                case "#microsoft.graph.windowsPhone81CompliancePolicy": {
                    return new WindowsPhone81CompliancePolicy();
                }
            }
        }
        return new DeviceCompliancePolicy();
    }

    @Nullable
    public List<DeviceCompliancePolicyAssignment> getAssignments() {
        return (List)this.backingStore.get("assignments");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDescription() {
        return (String)this.backingStore.get("description");
    }

    @Nullable
    public List<SettingStateDeviceSummary> getDeviceSettingStateSummaries() {
        return (List)this.backingStore.get("deviceSettingStateSummaries");
    }

    @Nullable
    public List<DeviceComplianceDeviceStatus> getDeviceStatuses() {
        return (List)this.backingStore.get("deviceStatuses");
    }

    @Nullable
    public DeviceComplianceDeviceOverview getDeviceStatusOverview() {
        return (DeviceComplianceDeviceOverview)this.backingStore.get("deviceStatusOverview");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("assignments", n -> this.setAssignments(n.getCollectionOfObjectValues(DeviceCompliancePolicyAssignment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("description", n -> this.setDescription(n.getStringValue()));
        deserializerMap.put("deviceSettingStateSummaries", n -> this.setDeviceSettingStateSummaries(n.getCollectionOfObjectValues(SettingStateDeviceSummary::createFromDiscriminatorValue)));
        deserializerMap.put("deviceStatuses", n -> this.setDeviceStatuses(n.getCollectionOfObjectValues(DeviceComplianceDeviceStatus::createFromDiscriminatorValue)));
        deserializerMap.put("deviceStatusOverview", n -> this.setDeviceStatusOverview((DeviceComplianceDeviceOverview)n.getObjectValue(DeviceComplianceDeviceOverview::createFromDiscriminatorValue)));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("scheduledActionsForRule", n -> this.setScheduledActionsForRule(n.getCollectionOfObjectValues(DeviceComplianceScheduledActionForRule::createFromDiscriminatorValue)));
        deserializerMap.put("userStatuses", n -> this.setUserStatuses(n.getCollectionOfObjectValues(DeviceComplianceUserStatus::createFromDiscriminatorValue)));
        deserializerMap.put("userStatusOverview", n -> this.setUserStatusOverview((DeviceComplianceUserOverview)n.getObjectValue(DeviceComplianceUserOverview::createFromDiscriminatorValue)));
        deserializerMap.put("version", n -> this.setVersion(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public List<DeviceComplianceScheduledActionForRule> getScheduledActionsForRule() {
        return (List)this.backingStore.get("scheduledActionsForRule");
    }

    @Nullable
    public List<DeviceComplianceUserStatus> getUserStatuses() {
        return (List)this.backingStore.get("userStatuses");
    }

    @Nullable
    public DeviceComplianceUserOverview getUserStatusOverview() {
        return (DeviceComplianceUserOverview)this.backingStore.get("userStatusOverview");
    }

    @Nullable
    public Integer getVersion() {
        return (Integer)this.backingStore.get("version");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("assignments", this.getAssignments());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("description", this.getDescription());
        writer.writeCollectionOfObjectValues("deviceSettingStateSummaries", this.getDeviceSettingStateSummaries());
        writer.writeCollectionOfObjectValues("deviceStatuses", this.getDeviceStatuses());
        writer.writeObjectValue("deviceStatusOverview", (Parsable)this.getDeviceStatusOverview(), new Parsable[0]);
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeCollectionOfObjectValues("scheduledActionsForRule", this.getScheduledActionsForRule());
        writer.writeCollectionOfObjectValues("userStatuses", this.getUserStatuses());
        writer.writeObjectValue("userStatusOverview", (Parsable)this.getUserStatusOverview(), new Parsable[0]);
        writer.writeIntegerValue("version", this.getVersion());
    }

    public void setAssignments(@Nullable List<DeviceCompliancePolicyAssignment> value) {
        this.backingStore.set("assignments", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDescription(@Nullable String value) {
        this.backingStore.set("description", (Object)value);
    }

    public void setDeviceSettingStateSummaries(@Nullable List<SettingStateDeviceSummary> value) {
        this.backingStore.set("deviceSettingStateSummaries", value);
    }

    public void setDeviceStatuses(@Nullable List<DeviceComplianceDeviceStatus> value) {
        this.backingStore.set("deviceStatuses", value);
    }

    public void setDeviceStatusOverview(@Nullable DeviceComplianceDeviceOverview value) {
        this.backingStore.set("deviceStatusOverview", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setScheduledActionsForRule(@Nullable List<DeviceComplianceScheduledActionForRule> value) {
        this.backingStore.set("scheduledActionsForRule", value);
    }

    public void setUserStatuses(@Nullable List<DeviceComplianceUserStatus> value) {
        this.backingStore.set("userStatuses", value);
    }

    public void setUserStatusOverview(@Nullable DeviceComplianceUserOverview value) {
        this.backingStore.set("userStatusOverview", (Object)value);
    }

    public void setVersion(@Nullable Integer value) {
        this.backingStore.set("version", (Object)value);
    }
}

