/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BucketAggregationRange;
import com.microsoft.graph.models.BucketAggregationSortProperty;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BucketAggregationDefinition
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public BucketAggregationDefinition() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static BucketAggregationDefinition createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BucketAggregationDefinition();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(6);
        deserializerMap.put("isDescending", n -> this.setIsDescending(n.getBooleanValue()));
        deserializerMap.put("minimumCount", n -> this.setMinimumCount(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("prefixFilter", n -> this.setPrefixFilter(n.getStringValue()));
        deserializerMap.put("ranges", n -> this.setRanges(n.getCollectionOfObjectValues(BucketAggregationRange::createFromDiscriminatorValue)));
        deserializerMap.put("sortBy", n -> this.setSortBy((BucketAggregationSortProperty)n.getEnumValue(BucketAggregationSortProperty::forValue)));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsDescending() {
        return (Boolean)this.backingStore.get("isDescending");
    }

    @Nullable
    public Integer getMinimumCount() {
        return (Integer)this.backingStore.get("minimumCount");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getPrefixFilter() {
        return (String)this.backingStore.get("prefixFilter");
    }

    @Nullable
    public List<BucketAggregationRange> getRanges() {
        return (List)this.backingStore.get("ranges");
    }

    @Nullable
    public BucketAggregationSortProperty getSortBy() {
        return (BucketAggregationSortProperty)((Object)this.backingStore.get("sortBy"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeBooleanValue("isDescending", this.getIsDescending());
        writer.writeIntegerValue("minimumCount", this.getMinimumCount());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("prefixFilter", this.getPrefixFilter());
        writer.writeCollectionOfObjectValues("ranges", this.getRanges());
        writer.writeEnumValue("sortBy", (Enum)this.getSortBy());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setIsDescending(@Nullable Boolean value) {
        this.backingStore.set("isDescending", (Object)value);
    }

    public void setMinimumCount(@Nullable Integer value) {
        this.backingStore.set("minimumCount", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPrefixFilter(@Nullable String value) {
        this.backingStore.set("prefixFilter", (Object)value);
    }

    public void setRanges(@Nullable List<BucketAggregationRange> value) {
        this.backingStore.set("ranges", value);
    }

    public void setSortBy(@Nullable BucketAggregationSortProperty value) {
        this.backingStore.set("sortBy", (Object)value);
    }
}

