/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.ackedqueue.ext;

import co.elastic.logstash.api.Metric;
import java.io.IOException;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.logstash.RubyUtil;
import org.logstash.ackedqueue.QueueFactoryExt;
import org.logstash.ackedqueue.Settings;
import org.logstash.ackedqueue.ext.JRubyAckedQueueExt;
import org.logstash.execution.AbstractWrappedQueueExt;
import org.logstash.execution.QueueReadClientBase;
import org.logstash.ext.JRubyAbstractQueueWriteClientExt;
import org.logstash.ext.JrubyAckedReadClientExt;
import org.logstash.ext.JrubyAckedWriteClientExt;
import org.logstash.ext.JrubyEventExtLibrary;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.plugins.NamespacedMetricImpl;

@JRubyClass(name={"WrappedAckedQueue"})
public final class JRubyWrappedAckedQueueExt
extends AbstractWrappedQueueExt {
    private static final long serialVersionUID = 1L;
    private JRubyAckedQueueExt queue;
    private QueueFactoryExt.BatchMetricMode batchMetricMode;

    @JRubyMethod(required=2, optional=1)
    public JRubyWrappedAckedQueueExt initialize(ThreadContext context, IRubyObject[] args) throws IOException {
        IRubyObject settings = args[0];
        if (!JavaUtil.isJavaObject((IRubyObject)settings)) {
            throw new IllegalArgumentException(String.format("Failed to instantiate JRubyWrappedAckedQueueExt with <%s:%s>", settings.getClass().getName(), settings));
        }
        IRubyObject batchMetricMode = args[1];
        Objects.requireNonNull(batchMetricMode, "batchMetricMode setting must be non-null");
        if (!JavaUtil.isJavaObject((IRubyObject)batchMetricMode)) {
            throw new IllegalArgumentException(String.format("Failed to instantiate JRubyWrappedAckedQueueExt with <%s:%s>", batchMetricMode.getClass().getName(), batchMetricMode));
        }
        Metric metric = JRubyWrappedAckedQueueExt.getApiMetric(args.length > 2 ? args[2] : null);
        Settings javaSettings = (Settings)JavaUtil.unwrapJavaObject((IRubyObject)settings);
        this.queue = JRubyAckedQueueExt.create(javaSettings, metric);
        this.batchMetricMode = (QueueFactoryExt.BatchMetricMode)((Object)JavaUtil.unwrapJavaObject((IRubyObject)batchMetricMode));
        this.queue.open();
        return this;
    }

    public static JRubyWrappedAckedQueueExt create(ThreadContext context, Settings settings, Metric metric, QueueFactoryExt.BatchMetricMode batchMetricMode) throws IOException {
        return new JRubyWrappedAckedQueueExt(context.runtime, RubyUtil.WRAPPED_ACKED_QUEUE_CLASS, settings, metric, batchMetricMode);
    }

    @Deprecated
    public JRubyWrappedAckedQueueExt(Ruby runtime, RubyClass metaClass, Settings settings, QueueFactoryExt.BatchMetricMode batchMetricMode) throws IOException {
        this(runtime, metaClass, settings, NamespacedMetricImpl.getNullMetric(), batchMetricMode);
    }

    public JRubyWrappedAckedQueueExt(Ruby runtime, RubyClass metaClass, Settings settings, Metric metric, QueueFactoryExt.BatchMetricMode batchMetricMode) throws IOException {
        super(runtime, metaClass);
        this.batchMetricMode = Objects.requireNonNull(batchMetricMode, "batchMetricMode setting must be non-null");
        this.queue = JRubyAckedQueueExt.create(settings, metric);
        this.queue.open();
    }

    public JRubyWrappedAckedQueueExt(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    private static Metric getApiMetric(IRubyObject metric) {
        if (Objects.isNull(metric) || metric.isNil()) {
            return NamespacedMetricImpl.getNullMetric();
        }
        if (metric instanceof AbstractMetricExt) {
            AbstractMetricExt rubyExtensionMetric = (AbstractMetricExt)metric;
            return rubyExtensionMetric.asApiMetric();
        }
        if (Metric.class.isAssignableFrom(metric.getJavaClass())) {
            return (Metric)metric.toJava(Metric.class);
        }
        throw new IllegalArgumentException(String.format("Object <%s> could not be converted to a metric", metric.inspect()));
    }

    @JRubyMethod(name={"queue"})
    public JRubyAckedQueueExt rubyGetQueue() {
        return this.queue;
    }

    public void close() throws IOException {
        this.queue.close();
    }

    @JRubyMethod(name={"push", "<<"})
    public void rubyPush(ThreadContext context, IRubyObject event) {
        this.queue.rubyWrite(context, ((JrubyEventExtLibrary.RubyEvent)event).getEvent());
    }

    @JRubyMethod(name={"read_batch"})
    public IRubyObject rubyReadBatch(ThreadContext context, IRubyObject size, IRubyObject wait) {
        return this.queue.rubyReadBatch(context, size, wait);
    }

    @JRubyMethod(name={"is_empty?"})
    public IRubyObject rubyIsEmpty(ThreadContext context) {
        return RubyBoolean.newBoolean((Ruby)context.runtime, (boolean)this.queue.isEmpty());
    }

    @Override
    protected JRubyAbstractQueueWriteClientExt getWriteClient(ThreadContext context) {
        return JrubyAckedWriteClientExt.create(this.queue);
    }

    @Override
    protected QueueReadClientBase getReadClient() {
        return JrubyAckedReadClientExt.create((IRubyObject)this.queue, this.batchMetricMode);
    }

    @Override
    protected IRubyObject doClose(ThreadContext context) {
        try {
            this.close();
        }
        catch (IOException e) {
            throw RubyUtil.newRubyIOError(context.runtime, e);
        }
        return context.nil;
    }
}

