"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventMergingBanner = exports.ENDPOINT_VERSION_SUPPORTING_EVENT_MERGING_BY_DEFAULT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/event_merging_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * The version from which we decrease event volume by default.
 */
const ENDPOINT_VERSION_SUPPORTING_EVENT_MERGING_BY_DEFAULT = exports.ENDPOINT_VERSION_SUPPORTING_EVENT_MERGING_BY_DEFAULT = '8.18';
const EventMergingBanner = exports.EventMergingBanner = /*#__PURE__*/(0, _react.memo)(({
  onDismiss
}) => {
  const {
    docLinks
  } = (0, _public.useKibana)().services;
  const bannerTitle = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.eventMergingBanner.title', {
    defaultMessage: "We've recently changed event collection"
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: bannerTitle,
    onDismiss: onDismiss,
    "data-test-subj": "eventMergingCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.eventMergingBanner.body",
    defaultMessage: "Elastic Agent {minVersion}+ produces less telemetry without reducing system visibility, which may impact existing event filters. For more about these changes and how to adjust your settings, visit our {documentation}.",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.securitySolution.eventMerging,
        target: "_blank",
        "data-test-subj": "eventMergingDocLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.eventMergingBanner.doc.link",
        defaultMessage: "documentation",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 17
        }
      })),
      minVersion: ENDPOINT_VERSION_SUPPORTING_EVENT_MERGING_BY_DEFAULT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })));
});
EventMergingBanner.displayName = 'EventMergingBanner';