"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointDetails = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _hooks = require("../../../../hooks");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _response_actions_log = require("../../../../components/endpoint_response_actions_list/response_actions_log");
var _policy_response = require("../../../../components/policy_response");
var _kibana = require("../../../../../common/lib/kibana");
var _routing = require("../../../../common/routing");
var _selectors = require("../../store/selectors");
var _hooks2 = require("../hooks");
var i18 = _interopRequireWildcard(require("../translations"));
var _actions_menu = require("./components/actions_menu");
var _endpoint_details_tabs = require("./components/endpoint_details_tabs");
var _endpoint_isolate_flyout_panel = require("./components/endpoint_isolate_flyout_panel");
var _flyout_header = require("./components/flyout_header");
var _endpoint_details_content = require("./endpoint_details_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/endpoint_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EndpointDetails = exports.EndpointDetails = /*#__PURE__*/(0, _react.memo)(() => {
  var _queryParams$selected, _hostInfo$metadata, _hostInfo$metadata2, _hostInfo$metadata2$h;
  const toasts = (0, _kibana.useToasts)();
  const queryParams = (0, _hooks2.useEndpointSelector)(_selectors.uiQueryParams);
  const {
    data: hostInfo,
    error: hostInfoError,
    isFetching: isHostInfoLoading
  } = (0, _hooks.useGetEndpointDetails)((_queryParams$selected = queryParams.selected_endpoint) !== null && _queryParams$selected !== void 0 ? _queryParams$selected : '');
  const show = (0, _hooks2.useEndpointSelector)(_selectors.showView);
  const {
    canAccessEndpointActionsLogManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const contentLoadingMarkup = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })), []);
  const getTabs = (0, _react.useCallback)(id => {
    const tabs = [{
      id: _endpoint_details_tabs.EndpointDetailsTabsTypes.overview,
      name: i18.OVERVIEW,
      route: (0, _routing.getEndpointDetailsPath)({
        ...queryParams,
        name: 'endpointDetails',
        selected_endpoint: id
      }),
      content: hostInfo === undefined ? contentLoadingMarkup : /*#__PURE__*/_react.default.createElement(_endpoint_details_content.EndpointDetailsContent, {
        hostInfo: hostInfo,
        policyInfo: hostInfo.policy_info,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 15
        }
      })
    }];

    // show the response actions history tab
    // only when the user has the required permission
    if (canAccessEndpointActionsLogManagement) {
      tabs.push({
        id: _endpoint_details_tabs.EndpointDetailsTabsTypes.activityLog,
        name: i18.ACTIVITY_LOG.tabTitle,
        route: (0, _routing.getEndpointDetailsPath)({
          ...queryParams,
          name: 'endpointActivityLog',
          selected_endpoint: id
        }),
        content: /*#__PURE__*/_react.default.createElement(_response_actions_log.ResponseActionsLog, {
          agentIds: id,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 20
          }
        })
      });
    }
    return tabs;
  }, [canAccessEndpointActionsLogManagement, contentLoadingMarkup, hostInfo, queryParams]);
  const showFlyoutFooter = show === 'details' || show === 'policy_response' || show === 'activity_log';
  (0, _react.useEffect)(() => {
    if (hostInfoError !== null) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.errorTitle', {
          defaultMessage: 'Could not find host'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.endpoint.details.errorBody', {
          defaultMessage: 'Please exit the flyout and select an available host.'
        })
      });
    }
  }, [hostInfoError, show, toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (show === 'policy_response' || show === 'isolate' || show === 'unisolate') && /*#__PURE__*/_react.default.createElement(_flyout_header.EndpointDetailsFlyoutHeader, {
    endpointId: hostInfo === null || hostInfo === void 0 ? void 0 : (_hostInfo$metadata = hostInfo.metadata) === null || _hostInfo$metadata === void 0 ? void 0 : _hostInfo$metadata.agent.id,
    hasBorder: true,
    hostname: hostInfo === null || hostInfo === void 0 ? void 0 : (_hostInfo$metadata2 = hostInfo.metadata) === null || _hostInfo$metadata2 === void 0 ? void 0 : (_hostInfo$metadata2$h = _hostInfo$metadata2.host) === null || _hostInfo$metadata2$h === void 0 ? void 0 : _hostInfo$metadata2$h.hostname,
    isHostInfoLoading: isHostInfoLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }), hostInfo === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 41
    }
  }), " ", /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 64
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (show === 'details' || show === 'activity_log') && /*#__PURE__*/_react.default.createElement(_endpoint_details_tabs.EndpointDetailsFlyoutTabs, {
    hostname: hostInfo.metadata.host.hostname,
    isHostInfoLoading: isHostInfoLoading
    // show overview tab if forcing response actions history
    // tab via URL without permission
    ,
    show: !canAccessEndpointActionsLogManagement ? 'details' : show,
    tabs: getTabs(hostInfo.metadata.agent.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }), show === 'policy_response' && /*#__PURE__*/_react.default.createElement(PolicyResponseFlyoutPanel, {
    hostMeta: hostInfo.metadata,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 42
    }
  }), (show === 'isolate' || show === 'unisolate') && /*#__PURE__*/_react.default.createElement(_endpoint_isolate_flyout_panel.EndpointIsolationFlyoutPanel, {
    hostMeta: hostInfo.metadata,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }), showFlyoutFooter && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "eui-textRight",
    "data-test-subj": "endpointDetailsFlyoutFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_actions_menu.ActionsMenu, {
    hostInfo: hostInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 15
    }
  }))));
});
EndpointDetails.displayName = 'EndpointDetails';
const PolicyResponseFlyoutPanel = /*#__PURE__*/(0, _react.memo)(({
  hostMeta
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "endpointDetailsPolicyResponseFlyoutBody",
    className: "endpointDetailsPolicyResponseFlyoutBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_response.PolicyResponseWrapper, {
    endpointId: hostMeta.agent.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  })));
});
PolicyResponseFlyoutPanel.displayName = 'PolicyResponseFlyoutPanel';