"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyEmptyState = exports.HostsEmptyState = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _user_privileges = require("../../common/components/user_privileges");
var _security_administration_onboarding = _interopRequireDefault(require("../images/security_administration_onboarding.svg"));
var _kibana = require("../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/management_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEXT_ALIGN_CENTER = (0, _react2.css)`
  text-align: center;
`;
const MAX_SIZE_ONBOARDING_LOGO = {
  maxWidth: 550,
  maxHeight: 420
};
const MissingFleetAccessInfo = /*#__PURE__*/_react.default.memo(() => {
  const {
    services
  } = (0, _kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": "noFleetAccess",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.onboarding.enableFleetAccess",
    defaultMessage: "Deploying Agents for the first time requires Fleet access. For more information, ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: `${services.docLinks.links.securitySolution.privileges}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.onboarding.onboardingDocsLink",
    defaultMessage: "view the Elastic Security documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  })));
});
MissingFleetAccessInfo.displayName = 'MissingFleetAccessInfo';
const PolicyEmptyState = exports.PolicyEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  onActionClick,
  actionDisabled,
  policyEntryPoint = false
}) => {
  const docLinks = (0, _kibana.useKibana)().services.docLinks;
  const {
    canAccessFleet,
    canWriteIntegrationPolicies,
    loading: authzLoading
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "emptyPolicyTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    className: "essentialAnimation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "policyOnboardingInstructions",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingTitle",
    defaultMessage: "Get started with Elastic Defend",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionOne",
    defaultMessage: "Protect your hosts with threat prevention, detection, and deep security data visibility.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  }, policyEntryPoint ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionTwo.fromPolicyPage",
    defaultMessage: "From this page, you can view and manage the Elastic Defend integration policies in your environment running Elastic Defend.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionTwo.fromEndpointPage",
    defaultMessage: "From this page, you can view and manage the hosts in your environment running Elastic Defend.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingSectionThree",
    defaultMessage: "To get started, add the Elastic Defend integration to your Agents. For more information, ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    href: `${docLinks.links.siem.guide}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.onboardingDocsLink",
    defaultMessage: "view the Elastic Security documentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }), authzLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 30
    }
  }), !authzLoading && canAccessFleet && canWriteIntegrationPolicies && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    onClick: onActionClick,
    isDisabled: actionDisabled,
    "data-test-subj": "onboardingStartButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policyList.actionButtonText",
    defaultMessage: "Add Elastic Defend",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 23
    }
  }))))), !authzLoading && !(canAccessFleet && canWriteIntegrationPolicies) && /*#__PURE__*/_react.default.createElement(MissingFleetAccessInfo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _security_administration_onboarding.default,
    size: "original",
    css: MAX_SIZE_ONBOARDING_LOGO,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 13
    }
  }))));
});
const EndpointsEmptyState = exports.HostsEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  onActionClick,
  actionDisabled,
  handleSelectableOnChange,
  selectionOptions,
  policyItems
}) => {
  const {
    getAppUrl
  } = (0, _kibana.useAppUrl)();
  const policyItemsWithoutAgentPolicy = (0, _react.useMemo)(() => policyItems.filter(policy => !policy.policy_ids.length), [policyItems]);
  const policiesNotAddedToAgentPolicyCallout = (0, _react.useMemo)(() => !!policyItemsWithoutAgentPolicy.length && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    iconType: "info",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.notAddedIntegrations.title', {
      defaultMessage: 'Integrations not added to an Agent policy'
    }),
    "data-test-subj": "integrationsNotAddedToAgentPolicyCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.description",
    defaultMessage: "The following Elastic Defend integrations aren't added to an Agent policy, so they can't be deployed to an Agent. Click on an integration to edit it, and add it to an Agent policy:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  }, policyItemsWithoutAgentPolicy.map(policyItem => /*#__PURE__*/_react.default.createElement("li", {
    key: policyItem.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: getAppUrl({
      appId: _common.INTEGRATIONS_PLUGIN_ID,
      path: _public.pagePathGetters.integration_policy_edit({
        packagePolicyId: policyItem.id
      })[1]
    }),
    "data-test-subj": "integrationWithoutAgentPolicyListItem",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 23
    }
  }, policyItem.name)))), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.visitIntegrations",
    defaultMessage: "You can also view a list of all {integrationPolicies}.",
    values: {
      integrationPolicies: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: getAppUrl({
          appId: _common.INTEGRATIONS_PLUGIN_ID,
          path: _public.pagePathGetters.integration_details_policies({
            pkgkey: 'endpoint'
          })[1]
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 250,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.list.notAddedIntegrations.integrationPolicies",
        defaultMessage: "Elastic Defend integration policies",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 25
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 17
    }
  })))), [getAppUrl, policyItemsWithoutAgentPolicy]);
  const policySteps = (0, _react.useMemo)(() => [{
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.stepOneTitle', {
      defaultMessage: 'Select the integration you want to use'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "m",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.stepOne",
      defaultMessage: "Select from existing integrations. This can be changed later.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 288,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
      options: selectionOptions,
      singleSelection: "always",
      isLoading: loading,
      listProps: {
        bordered: true,
        singleSelection: true
      },
      onChange: handleSelectableOnChange,
      "data-test-subj": "onboardingPolicySelect",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 289,
        columnNumber: 15
      }
    }, list => {
      if (loading) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 300,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.loadingPolicies",
          defaultMessage: "Loading integrations",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 301,
            columnNumber: 25
          }
        }));
      }
      if (!selectionOptions.length) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          color: "warning",
          "data-test-subj": "noIntegrationsAddedToAgentPoliciesCallout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 311,
            columnNumber: 23
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.list.noPoliciesAssignedToAgentPolicies",
          defaultMessage: "There are no Elastic Defend integrations added to Agent policies. To deploy Elastic Defend, add it to an Agent policy.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 315,
            columnNumber: 25
          }
        }));
      }
      return list;
    }), policiesNotAddedToAgentPolicyCallout)
  }, {
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.list.stepTwoTitle', {
      defaultMessage: 'Enroll your agents enabled with Elastic Defend through Fleet'
    }),
    status: actionDisabled ? 'disabled' : '',
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "m",
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.stepTwo",
      defaultMessage: "You'll be provided with the necessary commands to get started.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 19
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: onActionClick,
      isDisabled: actionDisabled,
      "data-test-subj": "onboardingStartButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.policyList.emptyCreateNewButton",
      defaultMessage: "Enroll Agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 19
      }
    }))))
  }], [selectionOptions, loading, handleSelectableOnChange, policiesNotAddedToAgentPolicyCallout, actionDisabled, onActionClick]);
  return /*#__PURE__*/_react.default.createElement(ManagementEmptyState, {
    loading: loading,
    dataTestSubj: "emptyHostsTable",
    steps: policySteps,
    headerComponent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.noEndpointsPrompt",
      defaultMessage: "Next step: Enroll an Agent with Elastic Defend",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 379,
        columnNumber: 11
      }
    }),
    bodyComponent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.list.noEndpointsInstructions",
      defaultMessage: "You've added the Elastic Defend integration. Now enroll your agents using the steps below.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 7
    }
  });
});
const ManagementEmptyState = /*#__PURE__*/_react.default.memo(({
  loading,
  dataTestSubj,
  steps,
  headerComponent,
  bodyComponent
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 403,
      columnNumber: 5
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    className: "essentialAnimation",
    "data-test-subj": "management-empty-state-loading-spinner",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 407,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 416,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    css: TEXT_ALIGN_CENTER,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 13
    }
  }, headerComponent)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 420,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    color: "subdued",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 421,
      columnNumber: 11
    }
  }, bodyComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 11
    }
  }), steps && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 426,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    "data-test-subj": 'onboardingSteps',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 17
    }
  })))));
});
PolicyEmptyState.displayName = 'PolicyEmptyState';
EndpointsEmptyState.displayName = 'HostsEmptyState';
ManagementEmptyState.displayName = 'ManagementEmptyState';