"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledButtonGroup = exports.EffectedPolicySelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _policy_selector = require("../policy_selector");
var _use_artifact_restricted_policy_assignments = require("../../hooks/artifacts/use_artifact_restricted_policy_assignments");
var _artifacts = require("../../hooks/artifacts");
var _use_license = require("../../../common/hooks/use_license");
var _translations = require("../../common/translations");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../common/components/user_privileges");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _artifacts2 = require("../../../../common/endpoint/service/artifacts");
var _utils = require("../../../../common/endpoint/service/artifacts/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/effected_policy_select/effected_policy_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledEuiFlexItemButtonGroup = (0, _styled.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${({
  theme
}) => theme.euiTheme.breakpoint.m}) {
    align-items: center;
  }
`;
const StyledButtonGroup = exports.StyledButtonGroup = (0, _styled.default)(_eui.EuiButtonGroup)`
  display: flex;
  justify-content: right;
  .euiButtonGroupButton {
    padding-right: ${({
  theme
}) => theme.euiTheme.size.l};
  }
`;
const EffectivePolicyFormContainer = _styled.default.div`
  .policy-name .euiSelectableListItem__text {
    text-decoration: none !important;
    color: ${({
  theme
}) => theme.euiTheme.colors.textParagraph} !important;
  }
`;
/**
 * Policy Selection component used on Endpoint Artifact forms for setting Global/Per-Policy assignment.
 */
const EffectedPolicySelect = exports.EffectedPolicySelect = /*#__PURE__*/(0, _react.memo)(({
  item,
  description,
  onChange,
  disabled = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isPlatinumPlus = (0, _use_license.useLicense)().isPlatinumPlus();
  const isSpaceAwarenessEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointManagementSpaceAwarenessEnabled');
  const canManageGlobalArtifacts = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canManageGlobalArtifacts;
  const {
    getTagsUpdatedBy
  } = (0, _artifacts.useGetUpdatedTags)(item);
  const artifactRestrictedPolicyIds = (0, _use_artifact_restricted_policy_assignments.useArtifactRestrictedPolicyAssignments)(item);
  const [selectedPolicyIds, setSelectedPolicyIds] = (0, _react.useState)((0, _artifacts2.getPolicyIdsFromArtifact)(item));
  const accessiblePolicyIds = (0, _react.useMemo)(() => {
    return selectedPolicyIds.filter(policyId => !artifactRestrictedPolicyIds.policyIds.includes(policyId));
  }, [artifactRestrictedPolicyIds.policyIds, selectedPolicyIds]);
  const isGlobal = (0, _react.useMemo)(() => (0, _artifacts2.isArtifactGlobal)(item), [item]);
  const selectedAssignmentType = (0, _react.useMemo)(() => {
    if (isSpaceAwarenessEnabled) {
      return canManageGlobalArtifacts && isGlobal ? 'globalPolicy' : 'perPolicy';
    }
    return isGlobal ? 'globalPolicy' : 'perPolicy';
  }, [canManageGlobalArtifacts, isGlobal, isSpaceAwarenessEnabled]);
  const toggleGlobal = (0, _react.useMemo)(() => {
    const isGlobalButtonDisabled = !isSpaceAwarenessEnabled ? false : !canManageGlobalArtifacts;
    return [{
      id: 'globalPolicy',
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.effectedPolicySelect.global', {
        defaultMessage: 'Global'
      }),
      iconType: selectedAssignmentType === 'globalPolicy' ? 'checkInCircleFilled' : 'empty',
      'data-test-subj': getTestId('global'),
      isDisabled: isGlobalButtonDisabled,
      toolTipContent: isGlobalButtonDisabled ? _translations.NO_PRIVILEGE_FOR_MANAGEMENT_OF_GLOBAL_ARTIFACT_MESSAGE : undefined
    }, {
      id: 'perPolicy',
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.effectedPolicySelect.perPolicy', {
        defaultMessage: 'Per Policy'
      }),
      iconType: selectedAssignmentType === 'perPolicy' ? 'checkInCircleFilled' : 'empty',
      'data-test-subj': getTestId('perPolicy')
    }];
  }, [canManageGlobalArtifacts, getTestId, isSpaceAwarenessEnabled, selectedAssignmentType]);
  const unAccessiblePolicies = (0, _react.useMemo)(() => {
    const additionalPolicyItems = [];
    if (artifactRestrictedPolicyIds.policyIds.length > 0) {
      additionalPolicyItems.push({
        label: _i18n.i18n.translate('xpack.securitySolution.effectedPolicySelect.unaccessibleGroupLabel', {
          defaultMessage: 'Assigned policies not accessible from current space'
        }),
        isGroupLabel: true,
        'data-test-subj': getTestId('unaccessibleGroupLabel')
      });
    }
    for (const policyId of artifactRestrictedPolicyIds.policyIds) {
      additionalPolicyItems.push({
        label: policyId,
        toolTipContent: _i18n.i18n.translate('xpack.securitySolution.effectedPolicySelect.unaccessiblePolicyTooltip', {
          defaultMessage: 'Policy is not accessible from the current space'
        }),
        disabled: true,
        checked: 'on',
        'data-test-subj': getTestId(`unAccessiblePolicy-${policyId}`)
      });
    }
    return additionalPolicyItems;
  }, [artifactRestrictedPolicyIds.policyIds, getTestId]);
  const handleOnPolicySelectChange = (0, _react.useCallback)(updatedSelectedPolicyIds => {
    const artifactCompleteSelectedPolicyIds = updatedSelectedPolicyIds.concat(...artifactRestrictedPolicyIds.policyIds);
    setSelectedPolicyIds(artifactCompleteSelectedPolicyIds);
    onChange({
      ...item,
      tags: getTagsUpdatedBy('policySelection', artifactCompleteSelectedPolicyIds.map(_utils.buildPerPolicyTag))
    });
  }, [artifactRestrictedPolicyIds.policyIds, getTagsUpdatedBy, item, onChange]);
  const handleGlobalButtonChange = (0, _react.useCallback)(selectedId => {
    onChange({
      ...item,
      tags: getTagsUpdatedBy('policySelection', selectedId === 'globalPolicy' ? [_artifacts2.GLOBAL_ARTIFACT_TAG] : selectedPolicyIds.concat(artifactRestrictedPolicyIds.policyIds).map(_utils.buildPerPolicyTag))
    });
  }, [artifactRestrictedPolicyIds.policyIds, getTagsUpdatedBy, item, onChange, selectedPolicyIds]);
  return /*#__PURE__*/_react.default.createElement(EffectivePolicyFormContainer, {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.effectedPolicySelect.assignmentSectionTitle",
    defaultMessage: "Assignment",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": getTestId('description'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  }, description ? description : _i18n.i18n.translate('xpack.securitySolution.effectedPolicySelect.assignmentSectionDescription', {
    defaultMessage: 'Assign globally across all policies, or assign it to specific policies.'
  })))), /*#__PURE__*/_react.default.createElement(StyledEuiFlexItemButtonGroup, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(StyledButtonGroup, {
    legend: "Global Policy Toggle",
    options: toggleGlobal,
    idSelected: selectedAssignmentType,
    onChange: handleGlobalButtonChange,
    color: "primary",
    "data-test-subj": getTestId('byPolicyGlobalButtonGroup'),
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 9
    }
  }), selectedAssignmentType === 'perPolicy' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_policy_selector.PolicySelector, {
    selectedPolicyIds: accessiblePolicyIds,
    additionalListItems: unAccessiblePolicies,
    onChange: handleOnPolicySelectChange,
    "data-test-subj": getTestId('policiesSelector'),
    useCheckbox: true,
    showPolicyLink: true,
    isDisabled: isGlobal || !isPlatinumPlus || disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 13
    }
  })), artifactRestrictedPolicyIds.policyIds.length > 0 && !isGlobal && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    "data-test-subj": getTestId('unAccessiblePoliciesCallout'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, (0, _translations.ARTIFACT_POLICIES_NOT_ACCESSIBLE_IN_ACTIVE_SPACE_MESSAGE)(artifactRestrictedPolicyIds.policyIds.length))));
});
EffectedPolicySelect.displayName = 'EffectedPolicySelectNew';