"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomScriptSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_custom_scripts = require("../../../hooks/custom_scripts/use_get_custom_scripts");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _kibana = require("../../../../common/lib/kibana");
var _hooks = require("../shared/hooks");
var _constants = require("../shared/constants");
var _shared = require("../shared");
var _utils = require("../shared/utils");
var _translations = require("../../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console_argument_selectors/custom_scripts_selector/custom_script_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * State for the custom script selector component
 */

/**
 * A Console Argument Selector component that enables the user to select from available custom scripts
 */
const CustomScriptSelector = exports.CustomScriptSelector = /*#__PURE__*/(0, _react.memo)(({
  value,
  valueText,
  argName,
  argIndex,
  onChange,
  store: _store,
  command,
  requestFocus
}) => {
  var _command$commandDefin;
  const testId = (0, _use_test_id_generator.useTestIdGenerator)(`scriptSelector-${command.commandDefinition.name}-${argIndex}`);
  const {
    agentType,
    platform
  } = (_command$commandDefin = command.commandDefinition.meta) !== null && _command$commandDefin !== void 0 ? _command$commandDefin : {};
  const scriptsApiQueryParams = (0, _react.useMemo)(() => {
    if (agentType === 'sentinel_one' && platform) {
      return {
        osType: platform
      };
    }
    return {};
  }, [agentType, platform]);

  // Because the console supports multiple instances of the same argument, we need to ensure that
  // if the command was defined to now allow multiples, that we only render the first one.
  const shouldRender = (0, _react.useMemo)(() => {
    var _command$commandDefin2;
    const argDefinition = (_command$commandDefin2 = command.commandDefinition.args) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2[argName];
    return (argDefinition === null || argDefinition === void 0 ? void 0 : argDefinition.allowMultiples) || argIndex === 0;
  }, [argIndex, argName, command.commandDefinition.args]);
  const {
    data = [],
    isLoading: isLoadingScripts,
    error: scriptsError
  } = (0, _use_get_custom_scripts.useGetCustomScripts)(agentType, scriptsApiQueryParams, {
    enabled: shouldRender
  });
  const scriptsOptions = (0, _react.useMemo)(() => {
    return (0, _shared.transformCustomScriptsToOptions)(data, value);
  }, [data, value]);
  const state = (0, _hooks.useBaseSelectorState)(_store, value);
  (0, _react.useEffect)(() => {
    // If the argument selector should not be rendered, then at least set the `value` to a string
    // so that the normal com,and argument validations can be invoked if the user still ENTERs the command
    if (!shouldRender && value !== '') {
      onChange({
        value: '',
        valueText: '',
        store: state
      });
    } else if (
    // For SentinelOne: If a `value` is set, but we have no `selectedOption`, then the component
    // might be getting initialized from either console input history or from a user's past action.
    // Ensure that we set `selectedOption` once we get the list of scripts
    shouldRender && agentType === 'sentinel_one' && value && !(state !== null && state !== void 0 && state.selectedOption) && data.length > 0) {
      const preSelectedScript = data.find(script => script.name === value);

      // If script not found, then reset value/valueText
      if (!preSelectedScript) {
        onChange({
          value: '',
          valueText: '',
          store: state
        });
      } else {
        onChange({
          value,
          valueText,
          store: {
            ...state,
            selectedOption: preSelectedScript
          }
        });
      }
    }
  }, [agentType, data, onChange, shouldRender, state, value, valueText]);
  const {
    services: {
      notifications
    }
  } = (0, _kibana.useKibana)();
  const {
    handleOpenPopover,
    handleClosePopover
  } = (0, _hooks.useBaseSelectorHandlers)(state, onChange, value || '', valueText || '');
  const isAwaitingRenderDelay = (0, _hooks.useRenderDelay)();
  (0, _hooks.useFocusManagement)(state.isPopoverOpen, requestFocus);
  (0, _shared.useGenericErrorToast)(scriptsError, notifications, _translations.ERROR_LOADING_CUSTOM_SCRIPTS);
  const handleSelection = (0, _react.useCallback)((newOptions, _event, changedOption) => {
    const handler = (0, _utils.createSelectionHandler)(onChange, state);
    handler(newOptions, _event, changedOption);
  }, [onChange, state]);
  const renderOption = (0, _react.useCallback)(option => {
    const hasDescription = 'description' in option && option.description;
    const hasToolTipContent = 'toolTipContent' in option && option.toolTipContent;
    const descriptionText = hasDescription ? String(option.description) : '';
    const toolTipText = hasToolTipContent ? String(option.toolTipContent) : '';
    const content = /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": testId('script'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: _constants.SHARED_TRUNCATION_STYLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": `${option.label}-label`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 13
      }
    }, option.label)), hasDescription ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "right",
      content: descriptionText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": `${option.label}-description`,
      color: "subdued",
      size: "s",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      css: _constants.SHARED_TRUNCATION_STYLE,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 17
      }
    }, descriptionText))) : null);

    // If the option has toolTipContent (typically for disabled options), wrap in tooltip
    if (hasToolTipContent) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "right",
        content: toolTipText,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 11
        }
      }, content);
    }
    return content;
  }, [testId]);
  if (isAwaitingRenderDelay || isLoadingScripts && !scriptsError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": testId('loading'),
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 12
      }
    });
  }
  return shouldRender ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: state.isPopoverOpen,
    offset: 10,
    panelStyle: {
      padding: 0,
      minWidth: _constants.CUSTOM_SCRIPTS_CONFIG.minWidth
    },
    "data-test-subj": testId(),
    closePopover: handleClosePopover,
    panelProps: {
      'data-test-subj': testId('popoverPanel')
    },
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _constants.CUSTOM_SCRIPTS_CONFIG.tooltipText,
      position: "top",
      display: "block",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center",
      gutterSize: "none",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      onClick: handleOpenPopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 213,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      title: valueText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    }, valueText || _constants.CUSTOM_SCRIPTS_CONFIG.initialLabel)))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 5
    }
  }, state.isPopoverOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    id: _constants.CUSTOM_SCRIPTS_CONFIG.selectableId,
    searchable: true,
    options: scriptsOptions,
    onChange: handleSelection,
    renderOption: renderOption,
    singleSelection: true,
    searchProps: {
      placeholder: valueText || _constants.CUSTOM_SCRIPTS_CONFIG.initialLabel,
      autoFocus: true,
      onKeyDown: _utils.createKeyDownHandler
    },
    listProps: {
      rowHeight: _constants.CUSTOM_SCRIPTS_CONFIG.rowHeight,
      showIcons: true,
      textWrap: 'truncate'
    },
    errorMessage: scriptsError ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.customScriptSelector.errorLoading",
      defaultMessage: "Error loading scripts",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 15
      }
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: {
      margin: 5
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }, search), list))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    "data-test-subj": testId('noMultipleArgs'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.customScriptSelector.noMultipleArgs",
    defaultMessage: "Argument is only supported once per command",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 7
    }
  }));
});
CustomScriptSelector.displayName = 'CustomScriptSelector';