"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/flyout_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Title component with optional icon to indicate the type of document, can be used for text or a link
 */
const FlyoutTitle = exports.FlyoutTitle = /*#__PURE__*/(0, _react.memo)(({
  title,
  iconType,
  iconColor,
  isLink = false,
  'data-test-subj': dataTestSubj
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const titleIcon = (0, _react.useMemo)(() => {
    return iconType ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: iconColor,
      type: iconType,
      size: "m",
      className: "eui-alignBaseline",
      "data-test-subj": `${dataTestSubj}Icon`,
      css: (0, _react2.css)`
            margin-right: ${euiTheme.size.xs};
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }) : null;
  }, [iconType, iconColor, dataTestSubj, euiTheme.size.xs]);
  const titleComponent = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s",
      "data-test-subj": `${dataTestSubj}Text`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: isLink ? euiTheme.colors.textPrimary : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 13
      }
    }, title)));
  }, [dataTestSubj, title, isLink, euiTheme.colors.textPrimary]);
  const linkIcon = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'popout',
      size: "m",
      css: (0, _react2.css)`
            margin-bottom: ${euiTheme.size.xs};
          `,
      "data-test-subj": `${dataTestSubj}LinkIcon`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    });
  }, [dataTestSubj, euiTheme.size.xs]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                word-break: break-word;
                display: -webkit-box;
                -webkit-line-clamp: 3;
                -webkit-box-orient: vertical;
                overflow: hidden;
                text-overflow: ellipsis;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, titleIcon, titleComponent)), isLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 22
    }
  }, linkIcon)));
});
FlyoutTitle.displayName = 'FlyoutTitle';