"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getManagedUserTableColumns = void 0;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _default_renderer = require("../../../../timelines/components/field_renderers/default_renderer");
var i18n = _interopRequireWildcard(require("../translations"));
var _empty_value = require("../../../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/utils/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldColumn = ({
  label,
  field
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
        font-weight: ${euiTheme.font.weight.medium};
        color: ${euiTheme.colors.textHeading};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }, label !== null && label !== void 0 ? label : field);
};
const fieldColumn = {
  name: i18n.FIELD_COLUMN_TITLE,
  field: 'label',
  render: (label, {
    field
  }) => /*#__PURE__*/_react2.default.createElement(FieldColumn, {
    label: label,
    field: field !== null && field !== void 0 ? field : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 41
    }
  })
};
const getManagedUserTableColumns = contextID => [fieldColumn, {
  name: i18n.VALUES_COLUMN_TITLE,
  field: 'value',
  render: (value, {
    field
  }) => {
    return field && value ? /*#__PURE__*/_react2.default.createElement(_default_renderer.DefaultFieldRenderer, {
      rowItems: value.map(() => value.toString()),
      attrName: field,
      idPrefix: contextID ? `managedUser-${contextID}` : 'managedUser',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }) : (0, _empty_value.defaultToEmptyTag)(value);
  }
}];
exports.getManagedUserTableColumns = getManagedUserTableColumns;