"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowSuppressedAlerts = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if document has kibana.alert.suppression.docs_count field with values
 */
const useShowSuppressedAlerts = ({
  getFieldsData
}) => {
  const alertSuppressionField = getFieldsData(_ruleDataUtils.ALERT_SUPPRESSION_DOCS_COUNT);
  const alertSuppressionCount = alertSuppressionField ? parseInt(alertSuppressionField[0], 10) : 0;
  return {
    show: Boolean(alertSuppressionField),
    alertSuppressionCount
  };
};
exports.useShowSuppressedAlerts = useShowSuppressedAlerts;