"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MisconfigurationsInsight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_misconfiguration_preview = require("@kbn/cloud-security-posture/src/hooks/use_misconfiguration_preview");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _insight_distribution_bar = require("./insight_distribution_bar");
var _misconfiguration_preview = require("../../../../cloud_security_posture/components/misconfiguration/misconfiguration_preview");
var _formatted_number = require("../../../../common/components/formatted_number");
var _preview_link = require("../../../shared/components/preview_link");
var _context = require("../context");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _left_panel_header = require("../../../entity_details/shared/components/left_panel/left_panel_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/misconfiguration_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Displays a distribution bar with the count of total misconfigurations for a given entity
 */
const MisconfigurationsInsight = ({
  name,
  fieldName,
  direction,
  'data-test-subj': dataTestSubj,
  telemetryKey,
  openDetailsPanel
}) => {
  const renderingId = (0, _eui.useGeneratedHtmlId)();
  const {
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    data
  } = (0, _use_misconfiguration_preview.useMisconfigurationPreview)({
    query: (0, _cloudSecurityPostureCommon.buildGenericEntityFlyoutPreviewQuery)(fieldName, name),
    sort: [],
    enabled: true,
    pageSize: 1
  });
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const passedFindings = (data === null || data === void 0 ? void 0 : data.count.passed) || 0;
  const failedFindings = (data === null || data === void 0 ? void 0 : data.count.failed) || 0;
  const totalFindings = (0, _react.useMemo)(() => passedFindings + failedFindings, [passedFindings, failedFindings]);
  const shouldRender = totalFindings > 0; // this component only renders if there are findings

  (0, _react.useEffect)(() => {
    if (shouldRender && telemetryKey) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, telemetryKey);
    }
  }, [shouldRender, telemetryKey, renderingId]);
  const misconfigurationsStats = (0, _misconfiguration_preview.useGetFindingsStats)(passedFindings, failedFindings);
  const count = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin-top: ${euiTheme.size.xs};
          margin-bottom: ${euiTheme.size.xs};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, isNewNavigationEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.insights.misconfiguration.misconfigurationCountTooltip",
      defaultMessage: "Opens {count, plural, one {this misconfiguration} other {these misconfigurations}} in a new flyout",
      values: {
        count: totalFindings
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `${dataTestSubj}-count`,
    onClick: () => openDetailsPanel({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
      subTab: _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalFindings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: fieldName,
    value: name,
    scopeId: scopeId,
    "data-test-subj": `${dataTestSubj}-count`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalFindings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }))), [totalFindings, fieldName, name, scopeId, dataTestSubj, euiTheme.size, isNewNavigationEnabled, openDetailsPanel]);
  if (!shouldRender) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_insight_distribution_bar.InsightDistributionBar, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.insights.misconfigurationsTitle",
      defaultMessage: "Misconfigurations:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }),
    stats: misconfigurationsStats,
    count: count,
    direction: direction,
    "data-test-subj": `${dataTestSubj}-distribution-bar`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }));
};
exports.MisconfigurationsInsight = MisconfigurationsInsight;
MisconfigurationsInsight.displayName = 'MisconfigurationsInsight';