"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIMESTAMP_DATE_FORMAT = exports.CorrelationsDetailsAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _Either = require("fp-ts/Either");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cell_tooltip_wrapper = require("../../shared/components/cell_tooltip_wrapper");
var _severity_badge = require("../../../../common/components/severity_badge");
var _use_paginated_alerts = require("../hooks/use_paginated_alerts");
var _investigate_in_timeline_button = require("../../../../common/components/event_details/investigate_in_timeline_button");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _translations = require("../../../../detections/components/alerts_table/translations");
var _use_action_cell_data_provider = require("../../../../common/components/event_details/use_action_cell_data_provider");
var _alert_preview_button = require("../../../shared/components/alert_preview_button");
var _preview_link = require("../../../shared/components/preview_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/correlations_details_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TIMESTAMP_DATE_FORMAT = exports.TIMESTAMP_DATE_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
const dataProviderLimit = 5;
/**
 * Renders paginated alert array based on the provided alertIds
 */
const CorrelationsDetailsAlertsTable = ({
  title,
  loading,
  alertIds,
  scopeId,
  eventId,
  noItemsMessage,
  'data-test-subj': dataTestSubj
}) => {
  const {
    setPagination,
    setSorting,
    data,
    loading: alertsLoading,
    paginationConfig,
    sorting,
    error
  } = (0, _use_paginated_alerts.usePaginatedAlerts)(alertIds || []);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      const {
        index: pageIndex,
        size: pageSize
      } = page;
      setPagination({
        pageIndex,
        pageSize
      });
    }
    if (sort) {
      setSorting(sort);
    }
  }, [setPagination, setSorting]);
  const mappedData = (0, _react.useMemo)(() => {
    return data.map(hit => {
      var _hit$fields;
      return {
        fields: (_hit$fields = hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {},
        id: hit._id,
        index: hit._index
      };
    }).map(dataWithMeta => {
      const res = Object.keys(dataWithMeta.fields).reduce((result, fieldName) => {
        var _dataWithMeta$fields, _dataWithMeta$fields$, _dataWithMeta$fields2;
        result[fieldName] = ((_dataWithMeta$fields = dataWithMeta.fields) === null || _dataWithMeta$fields === void 0 ? void 0 : (_dataWithMeta$fields$ = _dataWithMeta$fields[fieldName]) === null || _dataWithMeta$fields$ === void 0 ? void 0 : _dataWithMeta$fields$[0]) || ((_dataWithMeta$fields2 = dataWithMeta.fields) === null || _dataWithMeta$fields2 === void 0 ? void 0 : _dataWithMeta$fields2[fieldName]);
        return result;
      }, {});
      res.id = dataWithMeta.id;
      res.index = dataWithMeta.index;
      return res;
    });
  }, [data]);
  const shouldUseFilters = Boolean(alertIds && alertIds.length && alertIds.length >= dataProviderLimit);
  const dataProviders = (0, _react.useMemo)(() => shouldUseFilters ? null : getDataProviders(scopeId, eventId, alertIds), [alertIds, shouldUseFilters, scopeId, eventId]);
  const filters = (0, _react.useMemo)(() => shouldUseFilters ? getFilters(alertIds) : null, [alertIds, shouldUseFilters]);
  const columns = (0, _react.useMemo)(() => [{
    render: row => /*#__PURE__*/_react.default.createElement(_alert_preview_button.AlertPreviewButton, {
      id: row.id,
      indexName: row.index,
      "data-test-subj": `${dataTestSubj}AlertPreviewButton`,
      scopeId: scopeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }),
    width: '5%'
  }, {
    field: '@timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.timestampColumnLabel",
      defaultMessage: "Timestamp",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 11
      }
    }),
    truncateText: true,
    dataType: 'date',
    render: value => {
      const date = (0, _eui.formatDate)(value, TIMESTAMP_DATE_FORMAT);
      return /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
        tooltip: date,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 15
        }
      }, date));
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.ruleColumnLabel",
      defaultMessage: "Rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    }),
    truncateText: true,
    render: row => {
      const ruleName = row[_ruleDataUtils.ALERT_RULE_NAME];
      const ruleId = row['kibana.alert.rule.uuid'];
      return /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
        tooltip: ruleName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
        field: _ruleDataUtils.ALERT_RULE_NAME,
        value: ruleName,
        scopeId: scopeId,
        ruleId: ruleId,
        "data-test-subj": `${dataTestSubj}RulePreview`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 17
        }
      }, ruleName)));
    }
  }, {
    field: _ruleDataUtils.ALERT_REASON,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.reasonColumnLabel",
      defaultMessage: "Reason",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }),
    truncateText: true,
    render: value => /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
      tooltip: value,
      anchorPosition: "left",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 13
      }
    }, value))
  }, {
    field: 'kibana.alert.severity',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.severityColumnLabel",
      defaultMessage: "Severity",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 11
      }
    }),
    truncateText: true,
    render: value => {
      const decodedSeverity = _securitysolutionIoTsAlertingTypes.Severity.decode(value);
      const renderValue = (0, _Either.isRight)(decodedSeverity) ? /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
        value: decodedSeverity.right,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 209,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 211,
          columnNumber: 13
        }
      }, value);
      return /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
        tooltip: value,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 18
        }
      }, renderValue);
    }
  }], [scopeId, dataTestSubj]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title,
      iconType: 'warning',
      headerContent: alertIds && alertIds.length && alertIds.length > 0 ? /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": `${dataTestSubj}InvestigateInTimeline`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 227,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
        dataProviders: dataProviders,
        filters: filters,
        asEmptyButton: true,
        iconType: "timeline",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 15
        }
      }, _translations.ACTION_INVESTIGATE_IN_TIMELINE)) : null
    },
    content: {
      error
    },
    expand: {
      expandable: true,
      expandedOnFirstRender: true
    },
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": `${dataTestSubj}Table`,
    loading: loading || alertsLoading,
    items: mappedData,
    columns: columns,
    pagination: paginationConfig,
    sorting: sorting,
    onChange: onTableChange,
    noItemsMessage: noItemsMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 7
    }
  }));
};
exports.CorrelationsDetailsAlertsTable = CorrelationsDetailsAlertsTable;
const getFilters = alertIds => {
  if (alertIds && alertIds.length) {
    return [{
      meta: {
        alias: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.correlations.tableFilterLabel', {
          defaultMessage: 'Correlations Details Table Alert IDs.'
        }),
        type: 'phrases',
        key: '_id',
        params: [...alertIds],
        negate: false,
        disabled: false,
        value: alertIds.join()
      },
      query: {
        bool: {
          should: alertIds.map(id => {
            return {
              match_phrase: {
                _id: id
              }
            };
          }),
          minimum_should_match: 1
        }
      }
    }];
  }
  return null;
};
const getDataProviders = (scopeId, eventId, alertIds) => {
  if (alertIds && alertIds.length) {
    return alertIds.reduce((result, alertId, index) => {
      const id = `${scopeId}-${eventId}-event.id-${index}-${alertId}`;
      result.push((0, _use_action_cell_data_provider.getDataProvider)('_id', id, alertId));
      return result;
    }, []);
  }
  return null;
};