"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportExceptionListFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _use_import_exception_list = require("../../hooks/use_import_exception_list");
var i18n = _interopRequireWildcard(require("../../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/components/import_exceptions_list_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// eslint-disable-next-line react/display-name
const ImportExceptionListFlyout = exports.ImportExceptionListFlyout = /*#__PURE__*/_react.default.memo(({
  handleRefresh,
  http,
  addSuccess,
  addError,
  setDisplayImportListFlyout
}) => {
  var _importExceptionListS6;
  const filePickerRef = (0, _react.useRef)(null);
  const filePickerId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'filePicker'
  });
  const [files, setFiles] = (0, _react.useState)(null);
  const [overwrite, setOverwrite] = (0, _react.useState)(false);
  const [asNewList, setAsNewList] = (0, _react.useState)(false);
  const [alreadyExistingItem, setAlreadyExistingItem] = (0, _react.useState)(false);
  const [endpointListImporting, setEndpointListImporting] = (0, _react.useState)(false);
  const resetForm = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    if ((_filePickerRef$curren = filePickerRef.current) !== null && _filePickerRef$curren !== void 0 && _filePickerRef$curren.fileInput) {
      filePickerRef.current.fileInput.value = '';
      filePickerRef.current.handleChange();
    }
    setFiles(null);
    setAlreadyExistingItem(false);
    setEndpointListImporting(false);
    setAsNewList(false);
    setOverwrite(false);
  }, []);
  const {
    start: importExceptionList,
    ...importExceptionListState
  } = (0, _use_import_exception_list.useImportExceptionList)();
  const ctrl = (0, _react.useRef)(new AbortController());
  const handleImportExceptionList = (0, _react.useCallback)(() => {
    if (!importExceptionListState.loading && files) {
      ctrl.current = new AbortController();
      Array.from(files).forEach(file => importExceptionList({
        file,
        http,
        signal: ctrl.current.signal,
        overwrite,
        overwriteExceptions: overwrite,
        asNewList
      }));
    }
  }, [asNewList, files, http, importExceptionList, importExceptionListState.loading, overwrite]);
  const handleImportSuccess = (0, _react.useCallback)(response => {
    resetForm();
    addSuccess({
      title: i18n.UPLOAD_SUCCESS_TITLE
    });
    handleRefresh();
  }, [resetForm, addSuccess, handleRefresh]);
  const handleImportErrors = (0, _react.useCallback)(errors => {
    errors.forEach(error => {
      if (!error.error.message.includes('AbortError')) {
        addError(error.error.message, {
          title: i18n.UPLOAD_ERROR
        });
      }
    });
  }, [addError]);
  (0, _react.useEffect)(() => {
    if (!importExceptionListState.loading) {
      var _importExceptionListS;
      if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS = importExceptionListState.result) !== null && _importExceptionListS !== void 0 && _importExceptionListS.success) {
        handleImportSuccess(importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.result);
      } else {
        var _importExceptionListS2, _importExceptionListS4;
        const errorsToDisplay = [];
        // @ts-expect-error
        if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS2 = importExceptionListState.error) !== null && _importExceptionListS2 !== void 0 && _importExceptionListS2.body) {
          var _importExceptionListS3;
          errorsToDisplay.push({
            // @ts-expect-error
            error: {
              ...(importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS3 = importExceptionListState.error) === null || _importExceptionListS3 === void 0 ? void 0 : _importExceptionListS3.body)
            }
          });
        }
        if (importExceptionListState !== null && importExceptionListState !== void 0 && (_importExceptionListS4 = importExceptionListState.result) !== null && _importExceptionListS4 !== void 0 && _importExceptionListS4.errors) {
          var _importExceptionListS5;
          importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS5 = importExceptionListState.result) === null || _importExceptionListS5 === void 0 ? void 0 : _importExceptionListS5.errors.forEach(err => {
            if (err.error.message.includes('already exists')) {
              setAlreadyExistingItem(true);
              if (err.error.message.includes(`Found that list_id: "${_securitysolutionListConstants.ENDPOINT_LIST_ID}" already exists`)) {
                setEndpointListImporting(true);
              }
            }
            errorsToDisplay.push(err);
          });
        }
        handleImportErrors(errorsToDisplay);
      }
    }
  }, [handleImportErrors, handleImportSuccess, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.error, importExceptionListState.loading, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : importExceptionListState.result, importExceptionListState === null || importExceptionListState === void 0 ? void 0 : (_importExceptionListS6 = importExceptionListState.result) === null || _importExceptionListS6 === void 0 ? void 0 : _importExceptionListS6.errors]);
  const handleFileChange = (0, _react.useCallback)(inputFiles => {
    setFiles(inputFiles !== null && inputFiles !== void 0 ? inputFiles : null);
  }, []);
  const importExceptionListFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'importExceptionListFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    size: "s",
    onClose: () => setDisplayImportListFlyout(false),
    "aria-labelledby": importExceptionListFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: importExceptionListFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }, i18n.IMPORT_EXCEPTION_LIST_HEADER))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, i18n.IMPORT_EXCEPTION_LIST_BODY), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: filePickerId,
    multiple: true,
    ref: filePickerRef,
    initialPromptText: i18n.IMPORT_PROMPT,
    onChange: handleFileChange,
    display: 'large',
    "aria-label": "Use aria labels when no actual label is in use",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }), alreadyExistingItem && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 15
    }
  }, i18n.IMPORT_EXCEPTION_LIST_WARNING), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'basicCheckboxId',
    label: i18n.IMPORT_EXCEPTION_LIST_OVERWRITE,
    checked: overwrite,
    "data-test-subj": "importExceptionListOverwriteExistingCheckbox",
    onChange: e => {
      setOverwrite(!overwrite);
      setAsNewList(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: endpointListImporting ? i18n.IMPORT_EXCEPTION_ENDPOINT_LIST_WARNING : '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'createNewListCheckbox',
    label: i18n.IMPORT_EXCEPTION_LIST_AS_NEW_LIST,
    "data-test-subj": "importExceptionListCreateNewCheckbox",
    checked: asNewList,
    disabled: endpointListImporting,
    onChange: e => {
      setAsNewList(!asNewList);
      setOverwrite(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "exceptionListsImportFormCloseBTN",
    iconType: "cross",
    onClick: () => setDisplayImportListFlyout(false),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  }, i18n.CLOSE_FLYOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "exception-lists-form-import-action",
    onClick: handleImportExceptionList,
    disabled: files == null || importExceptionListState.loading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, i18n.UPLOAD_BUTTON)))));
});