"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSeverityTableColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _formatted_number = require("../../../../common/components/formatted_number");
var _translations = require("../alerts_count_panel/translations");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _cell_actions = require("../../../../common/components/cell_actions");
var _helpers = require("../../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/severity_level_panel/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Returns the list of columns for the severity table for the KPI charts
 * @param showCellActions if true, add a third column for cell actions
 */
const useGetSeverityTableColumns = showCellActions => {
  const severityColors = (0, _risk_color_palette.useRiskSeverityColors)();
  return (0, _react.useMemo)(() => {
    const baseColumns = [{
      field: 'key',
      name: i18n.SEVERITY_LEVEL_COLUMN_TITLE,
      'data-test-subj': 'severityTable-severity',
      render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: severityColors[severity],
        textSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 43,
          columnNumber: 11
        }
      }, (0, _lodash.capitalize)(severity))
    }, {
      field: 'value',
      name: _translations.COUNT_TABLE_TITLE,
      dataType: 'number',
      'data-test-subj': 'severityTable-alertCount',
      width: '34%',
      render: alertCount => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        grow: false,
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
        count: alertCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }))
    }];
    if (showCellActions) {
      baseColumns.push({
        field: 'key',
        name: '',
        'data-test-subj': 'severityTable-actions',
        width: '16%',
        render: severity => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
          mode: _cell_actions.CellActionsMode.INLINE,
          visibleCellActions: 0,
          triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
          data: {
            field: _ruleDataUtils.ALERT_SEVERITY,
            value: severity
          },
          sourcererScopeId: (0, _helpers.getSourcererScopeId)(_securitysolutionDataTable.TableId.alertsOnAlertsPage),
          disabledActionTypes: [_cell_actions.SecurityCellActionType.SHOW_TOP_N],
          metadata: {
            scopeId: _securitysolutionDataTable.TableId.alertsOnAlertsPage
          },
          extraActionsIconType: "boxesVertical",
          extraActionsColor: "text",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 68,
            columnNumber: 11
          }
        })
      });
    }
    return baseColumns;
  }, [severityColors, showCellActions]);
};
exports.useGetSeverityTableColumns = useGetSeverityTableColumns;