"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverTooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../common/translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/popover_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Table column tooltip component utilizing EuiPopover for rich content like documentation links
 * @param columnName string Name of column to use as aria-label of button
 * @param children React.ReactNode of content to display in popover tooltip
 */
const PopoverTooltipComponent = ({
  columnName,
  children,
  anchorColor = 'primary'
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onClick = (0, _react.useCallback)(event => {
    setIsPopoverOpen(!isPopoverOpen);
    event.stopPropagation();
  }, [isPopoverOpen]);
  const onKeyDown = (0, _react.useCallback)(event => {
    if (_eui.keys.ENTER === event.key) {
      setIsPopoverOpen(!isPopoverOpen);
      event.preventDefault();
      event.stopPropagation();
    }
  }, [isPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: 'upCenter',
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": i18n.POPOVER_TOOLTIP_ARIA_LABEL(columnName),
      tabIndex: 0,
      onClick: onClick,
      onKeyDown: onKeyDown,
      color: anchorColor,
      type: "question",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, children);
};
const PopoverTooltip = exports.PopoverTooltip = /*#__PURE__*/_react.default.memo(PopoverTooltipComponent);
PopoverTooltip.displayName = 'PopoverTooltip';