"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchRuleFieldReadOnly = ThreatMatchRuleFieldReadOnly;
var _react = _interopRequireDefault(require("react"));
var _data_source = require("./fields/data_source/data_source");
var _kql_query = require("./fields/kql_query");
var _threat_index = require("./fields/threat_index/threat_index");
var _threat_indicator_path = require("./fields/threat_indicator_path/threat_indicator_path");
var _threat_mapping = require("./fields/threat_mapping/threat_mapping");
var _threat_query = require("./fields/threat_query/threat_query");
var _type = require("./fields/type/type");
var _alert_suppression = require("./fields/alert_suppression/alert_suppression");
var _utility_types = require("../../../../../../../common/utility_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/threat_match_rule_field_readonly.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ThreatMatchRuleFieldReadOnly({
  fieldName,
  finalDiffableRule
}) {
  switch (fieldName) {
    case 'alert_suppression':
      return /*#__PURE__*/_react.default.createElement(_alert_suppression.AlertSuppressionReadOnly, {
        alertSuppression: finalDiffableRule.alert_suppression,
        ruleType: finalDiffableRule.type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 32,
          columnNumber: 9
        }
      });
    case 'data_source':
      return /*#__PURE__*/_react.default.createElement(_data_source.DataSourceReadOnly, {
        dataSource: finalDiffableRule.data_source,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 14
        }
      });
    case 'kql_query':
      return /*#__PURE__*/_react.default.createElement(_kql_query.KqlQueryReadOnly, {
        kqlQuery: finalDiffableRule.kql_query,
        dataSource: finalDiffableRule.data_source,
        ruleType: finalDiffableRule.type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 9
        }
      });
    case 'threat_index':
      return /*#__PURE__*/_react.default.createElement(_threat_index.ThreatIndexReadOnly, {
        threatIndex: finalDiffableRule.threat_index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 14
        }
      });
    case 'threat_indicator_path':
      return /*#__PURE__*/_react.default.createElement(_threat_indicator_path.ThreatIndicatorPathReadOnly, {
        threatIndicatorPath: finalDiffableRule.threat_indicator_path,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      });
    case 'threat_mapping':
      return /*#__PURE__*/_react.default.createElement(_threat_mapping.ThreatMappingReadOnly, {
        threatMapping: finalDiffableRule.threat_mapping,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 14
        }
      });
    case 'threat_query':
      return /*#__PURE__*/_react.default.createElement(_threat_query.ThreatQueryReadOnly, {
        threatQuery: finalDiffableRule.threat_query,
        dataSource: finalDiffableRule.data_source,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 9
        }
      });
    case 'type':
      return /*#__PURE__*/_react.default.createElement(_type.TypeReadOnly, {
        type: finalDiffableRule.type,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 14
        }
      });
    default:
      return (0, _utility_types.assertUnreachable)(fieldName);
  }
}