"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityMappingReadOnly = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var _rule_about_section = require("../../../../rule_about_section");
var _empty_field_value_placeholder = require("../../empty_field_value_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/fields/severity_mapping/severity_mapping.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SeverityMappingReadOnly = ({
  severityMapping
}) => {
  const nonEmptySeverityMappingItems = severityMapping.filter(severityMappingItem => severityMappingItem.field !== '');
  if (nonEmptySeverityMappingItems.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.SEVERITY_MAPPING_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_empty_field_value_placeholder.EmptyFieldValuePlaceholder, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 30,
            columnNumber: 26
          }
        })
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 26,
        columnNumber: 7
      }
    });
  }
  const listItems = nonEmptySeverityMappingItems.map((severityMappingItem, index) => ({
    title: index === 0 ? ruleDetailsI18n.SEVERITY_MAPPING_FIELD_LABEL : '',
    description: /*#__PURE__*/_react.default.createElement(_rule_about_section.SeverityMappingItem, {
      severityMappingItem: severityMappingItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 18
      }
    })
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 10
    }
  });
};
exports.SeverityMappingReadOnly = SeverityMappingReadOnly;