"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MIN_VALUE = void 0;
exports.maxSignalsValidatorFactory = maxSignalsValidatorFactory;
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_VALUE = exports.MIN_VALUE = 1;
function maxSignalsValidatorFactory() {
  return _shared_imports.fieldValidators.numberGreaterThanField({
    than: MIN_VALUE,
    allowEquality: true,
    message: _i18n.i18n.translate('xpack.securitySolution.ruleManagement.ruleCreation.validation.maxSignals.greaterThanError', {
      values: {
        min: MIN_VALUE
      },
      defaultMessage: 'Max alerts must be greater than {min}.'
    })
  });
}