"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActionsDescription = void 0;
var _react = _interopRequireDefault(require("react"));
var _fp = require("lodash/fp");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/description_step/actions_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActionsDescription = ({
  actions
}) => {
  if (!actions.length) return null;
  return /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 16,
      columnNumber: 5
    }
  }, actions.map((action, index) => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 9
    }
  }, getActionTypeName(action.actionTypeId))));
};
const buildActionsDescription = (actions, title) => ({
  title: actions.length ? title : '',
  description: /*#__PURE__*/_react.default.createElement(ActionsDescription, {
    actions: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 16
    }
  })
});
exports.buildActionsDescription = buildActionsDescription;
const getActionTypeName = actionTypeId => {
  if (!actionTypeId) return '';
  const actionType = actionTypeId.split('.')[1];
  if (!actionType) return '';
  return (0, _fp.startCase)(actionType);
};