"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardTitle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _translations = require("../pages/details/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/components/dashboard_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DashboardTitleComponent = ({
  dashboardContainer,
  onTitleLoaded
}) => {
  const dashboardTitle = (0, _presentationPublishing.useStateFromPublishingSubject)(dashboardContainer.title$);
  const title = (0, _react.useMemo)(() => {
    return dashboardTitle && dashboardTitle.length !== 0 ? dashboardTitle : _translations.EDIT_DASHBOARD_TITLE;
  }, [dashboardTitle]);
  (0, _react.useEffect)(() => {
    onTitleLoaded(title);
  }, [dashboardContainer, title, onTitleLoaded]);
  return dashboardTitle != null ? /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 35
    }
  }, title) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 58
    }
  });
};
const DashboardTitle = exports.DashboardTitle = /*#__PURE__*/_react.default.memo(DashboardTitleComponent);