"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageListGrid = exports.IntegrationsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _constants = require("./constants");
var _view_facets = require("./view_facets");
var _constants2 = require("../../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/configurations/tabs/integrations/components/integrations_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PackageListGrid = exports.PackageListGrid = /*#__PURE__*/(0, _react.lazy)(async () => ({
  default: await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/fleet-plugin/public'))).then(module => module.PackageList()).then(pkg => pkg.PackageListGrid)
}));
const IntegrationsPage = exports.IntegrationsPage = /*#__PURE__*/_react.default.memo(({
  view,
  availableIntegrations,
  installedIntegrations,
  searchTerm,
  setSearchTerm
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              max-width: ${_constants.FACETS_MAX_WIDTH_PX}px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_view_facets.IntegrationViewFacets, {
    allCount: availableIntegrations.length,
    installedCount: installedIntegrations.length,
    selectedFacet: view,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              max-width: ${_constants.INTEGRATIONS_GRID_MAX_WIDTH_PX}px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(PackageListGrid, {
    calloutTopSpacerSize: "m",
    categories: [] // We do not want to show categories and subcategories as the search bar filter
    ,
    emptyStateStyles: {
      paddingTop: '16px'
    },
    list: view === _constants2.IntegrationsFacets.available ? availableIntegrations : view === _constants2.IntegrationsFacets.installed ? installedIntegrations : [],
    scrollElementId: 'integrations-scroll-container',
    selectedCategory: 'security',
    selectedSubCategory: '',
    searchTerm: searchTerm,
    setSearchTerm: setSearchTerm,
    setCategory: _lodash.noop,
    setUrlandPushHistory: _lodash.noop,
    setUrlandReplaceHistory: _lodash.noop,
    showCardLabels: true,
    showControls: false,
    showSearchTools: true,
    sortByFeaturedIntegrations: false,
    spacer: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 13
    }
  }))));
});
IntegrationsPage.displayName = 'IntegrationsGrid';