"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAlertToEcsSignal = exports.expandDottedObject = exports.buildAlertsQuery = void 0;
var _std = require("@kbn/std");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildAlertsQuery = alertIds => {
  if (alertIds.length === 0) {
    return {};
  }
  return {
    query: {
      bool: {
        filter: {
          ids: {
            values: alertIds
          }
        }
      }
    },
    size: 10000
  };
};
exports.buildAlertsQuery = buildAlertsQuery;
const formatAlertItem = item => {
  if (item != null && (0, _lodash.isPlainObject)(item)) {
    return Object.keys(item).reduce((acc, key) => ({
      ...acc,
      [key]: formatAlertItem(item[key])
    }), {});
  } else if (Array.isArray(item)) {
    return item.map(arrayItem => formatAlertItem(arrayItem));
  }
  return item;
};
const expandDottedField = (dottedFieldName, val) => {
  const parts = dottedFieldName.split('.');
  if (parts.length === 1) {
    return {
      [parts[0]]: val
    };
  } else {
    return {
      [parts[0]]: expandDottedField(parts.slice(1).join('.'), val)
    };
  }
};

/*
 * Expands an object with "dotted" fields to a nested object with unflattened fields.
 *
 * Example:
 *   expandDottedObject({
 *     "kibana.alert.depth": 1,
 *     "kibana.alert.ancestors": [{
 *       id: "d5e8eb51-a6a0-456d-8a15-4b79bfec3d71",
 *       type: "event",
 *       index: "signal_index",
 *       depth: 0,
 *     }],
 *   })
 *
 *   => {
 *     kibana: {
 *       alert: {
 *         ancestors: [
 *           id: "d5e8eb51-a6a0-456d-8a15-4b79bfec3d71",
 *           type: "event",
 *           index: "signal_index",
 *           depth: 0,
 *         ],
 *         depth: 1,
 *       },
 *     },
 *   }
 */
const expandDottedObject = dottedObj => {
  if (Array.isArray(dottedObj)) {
    return dottedObj;
  }
  return Object.entries(dottedObj).reduce((acc, [key, val]) => (0, _std.merge)(acc, expandDottedField(key, val)), {});
};
exports.expandDottedObject = expandDottedObject;
const formatAlertToEcsSignal = alert => {
  return expandDottedObject(alert);
};
exports.formatAlertToEcsSignal = formatAlertToEcsSignal;