"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulNewsFeed = void 0;
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("./helpers");
var _kibana = require("../../lib/kibana");
var _news_feed = require("./news_feed");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/news_feed/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatefulNewsFeed = exports.StatefulNewsFeed = /*#__PURE__*/_react.default.memo(({
  enableNewsFeedSetting,
  newsFeedSetting
}) => {
  const kibanaNewsfeedEnabled = (0, _kibana.useKibana)().services.newsfeed;
  const [enableNewsFeed] = (0, _kibana.useUiSetting$)(enableNewsFeedSetting);
  const [newsFeedUrlSetting] = (0, _kibana.useUiSetting$)(newsFeedSetting);
  const [news, setNews] = (0, _react.useState)(null);

  // respect kibana's global newsfeed.enabled setting
  const newsfeedEnabled = kibanaNewsfeedEnabled && enableNewsFeed;
  const newsFeedUrl = (0, _helpers.getNewsFeedUrl)({
    newsFeedUrlSetting,
    getKibanaVersion: () => _kibana.KibanaServices.getKibanaVersion()
  });
  (0, _react.useEffect)(() => {
    let canceled = false;
    const fetchData = async () => {
      try {
        const apiResponse = await (0, _helpers.fetchNews)({
          newsFeedUrl
        });
        if (!canceled) {
          setNews((0, _helpers.getNewsItemsFromApiResponse)(apiResponse));
        }
      } catch {
        if (!canceled) {
          setNews([]);
        }
      }
    };
    if (newsfeedEnabled) {
      fetchData();
    }
    return () => {
      canceled = true;
    };
  }, [newsfeedEnabled, newsFeedUrl]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, newsfeedEnabled ? /*#__PURE__*/_react.default.createElement(_news_feed.NewsFeed, {
    news: news,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 31
    }
  }) : null);
});
StatefulNewsFeed.displayName = 'StatefulNewsFeed';