"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabNavigationComponent = exports.TabNavigation = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _kibana = require("../../../lib/kibana");
var _telemetry = require("../../../lib/telemetry");
var _translations = require("../../../translations");
var _use_route_spy = require("../../../utils/route/use_route_spy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/navigation/tab_navigation/tab_navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TabNavigationItemComponent = ({
  disabled,
  hrefWithSearch,
  id,
  name,
  isSelected,
  isBeta,
  betaOptions
}) => {
  var _betaOptions$text;
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const handleClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateTo({
      path: hrefWithSearch,
      restoreScroll: true
    });
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, `${_telemetry.TELEMETRY_EVENT.TAB_CLICKED}${id}`);
  }, [navigateTo, hrefWithSearch, id]);
  const appHref = getAppUrl({
    path: hrefWithSearch
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-href": appHref,
    "data-test-subj": `navigation-${id}`,
    disabled: disabled,
    isSelected: isSelected,
    href: appHref,
    onClick: handleClick,
    append: isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: '#E0E5EE',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 25
      }
    }, (_betaOptions$text = betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text) !== null && _betaOptions$text !== void 0 ? _betaOptions$text : _translations.BETA),
    id: id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, name);
};
const TabNavigationItem = /*#__PURE__*/_react.default.memo(TabNavigationItemComponent);
const TabNavigationComponent = ({
  navTabs
}) => {
  const [{
    tabName
  }] = (0, _use_route_spy.useRouteSpy)();
  const mapLocationToTab = (0, _react.useCallback)(() => (0, _fp.getOr)('', 'id', Object.values(navTabs).find(item => tabName === item.id)), [tabName, navTabs]);
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(mapLocationToTab());
  (0, _react.useEffect)(() => {
    const currentTabSelected = mapLocationToTab();
    if (currentTabSelected !== selectedTabId) {
      setSelectedTabId(currentTabSelected);
    }

    // we do need navTabs in case the selectedTabId appears after initial load (ex. checking permissions for anomalies)
  }, [tabName, navTabs, mapLocationToTab, selectedTabId]);
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const renderTabs = (0, _react.useMemo)(() => Object.values(navTabs).map(tab => {
    const isSelected = selectedTabId === tab.id;
    return /*#__PURE__*/_react.default.createElement(TabNavigationItem, {
      key: `navigation-${tab.id}`,
      id: tab.id,
      hrefWithSearch: tab.href + search,
      name: tab.name,
      disabled: tab.disabled,
      isSelected: isSelected,
      isBeta: tab.isBeta,
      betaOptions: tab.betaOptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 11
      }
    });
  }), [navTabs, selectedTabId, search]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    "data-test-subj": "navigation-container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 10
    }
  }, renderTabs);
};
exports.TabNavigationComponent = TabNavigationComponent;
TabNavigationComponent.displayName = 'TabNavigationComponent';
const TabNavigation = exports.TabNavigation = /*#__PURE__*/_react.default.memo(TabNavigationComponent, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.navTabs, nextProps.navTabs));
TabNavigation.displayName = 'TabNavigation';