"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsDetailsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rison = require("@kbn/rison");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _helpers = require("@kbn/cloud-security-posture-common/utils/helpers");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _types = require("../../../overview/components/detection_response/alerts_by_status/types");
var _translations = require("../../../overview/components/detection_response/translations");
var _use_url_state = require("../../../common/hooks/use_url_state");
var _use_navigate_to_alerts_page_with_filters = require("../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _panel_keys = require("../../../flyout/document_details/shared/constants/panel_keys");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_query = require("../../../detections/containers/detection_engine/alerts/use_query");
var _constants = require("../../../detections/containers/detection_engine/alerts/constants");
var _use_signal_index = require("../../../detections/containers/detection_engine/alerts/use_signal_index");
var _helpers2 = require("../../../detections/components/alerts_kpis/severity_level_panel/helpers");
var _severity_badge = require("../../../common/components/severity_badge");
var _constants2 = require("../../../flyout/document_details/preview/constants");
var _types2 = require("../../../../common/types");
var _use_non_closed_alerts = require("../../hooks/use_non_closed_alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/csp_details/alerts_findings_details_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var KIBANA_ALERTS = /*#__PURE__*/function (KIBANA_ALERTS) {
  KIBANA_ALERTS["SEVERITY"] = "kibana.alert.severity";
  KIBANA_ALERTS["RULE_NAME"] = "kibana.alert.rule.name";
  KIBANA_ALERTS["WORKFLOW_STATUS"] = "kibana.alert.workflow_status";
  return KIBANA_ALERTS;
}(KIBANA_ALERTS || {});
const AlertsDetailsTable = exports.AlertsDetailsTable = /*#__PURE__*/(0, _react.memo)(({
  field,
  value
}) => {
  var _data$hits, _data$hits$hits;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.ENTITY_FLYOUT_EXPAND_MISCONFIGURATION_VIEW_VISITS);
  }, []);
  const [currentFilter, setCurrentFilter] = (0, _react.useState)('');
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(KIBANA_ALERTS.SEVERITY);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const alertsPagination = alerts => {
    let pageOfItems;
    if (!pageIndex && !pageSize) {
      pageOfItems = alerts;
    } else {
      const startIndex = pageIndex * pageSize;
      pageOfItems = alerts === null || alerts === void 0 ? void 0 : alerts.slice(startIndex, Math.min(startIndex + pageSize, alerts === null || alerts === void 0 ? void 0 : alerts.length));
    }
    return {
      pageOfItems,
      totalItemCount: alerts === null || alerts === void 0 ? void 0 : alerts.length
    };
  };
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const timerange = (0, _rison.encode)({
    global: {
      [_use_url_state.URL_PARAM_KEY.timerange]: {
        kind: 'absolute',
        from,
        to
      }
    }
  });
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    data,
    setQuery
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _helpers.buildEntityAlertsQuery)({
      field,
      to,
      from,
      queryValue: value,
      size: 500,
      severity: '',
      sortField,
      sortDirection
    }),
    queryName: _constants.ALERTS_QUERY_NAMES.BY_RULE_BY_STATUS,
    indexName: signalIndexName
  });
  const {
    filteredAlertsData: alertsData
  } = (0, _use_non_closed_alerts.useNonClosedAlerts)({
    field,
    value,
    to,
    from,
    queryId: `${_types.DETECTION_RESPONSE_ALERTS_BY_STATUS_ID}`
  });
  const severityMap = new Map();
  Object.keys(alertsData || {}).forEach(status => {
    var _alertsData$status;
    if (alertsData !== null && alertsData !== void 0 && (_alertsData$status = alertsData[status]) !== null && _alertsData$status !== void 0 && _alertsData$status.severities) {
      var _alertsData$status2;
      alertsData === null || alertsData === void 0 ? void 0 : (_alertsData$status2 = alertsData[status]) === null || _alertsData$status2 === void 0 ? void 0 : _alertsData$status2.severities.forEach(severity => {
        const currentSeverity = severityMap.get(severity.key) || 0;
        severityMap.set(severity.key, currentSeverity + severity.value);
      });
    }
  });
  const alertStats = Array.from(severityMap, ([key, count]) => ({
    key: (0, _lodash.capitalize)(key),
    count,
    color: (0, _helpers2.getSeverityColor)(key, euiTheme),
    filter: () => {
      setCurrentFilter(key);
      setQuery((0, _helpers.buildEntityAlertsQuery)({
        field,
        to,
        from,
        queryValue: value,
        size: 500,
        severity: key,
        sortField,
        sortDirection
      }));
    },
    isCurrentFilter: currentFilter === key,
    reset: event => {
      setCurrentFilter('');
      setQuery((0, _helpers.buildEntityAlertsQuery)({
        field,
        to,
        from,
        queryValue: value,
        size: 500,
        severity: ''
      }));
      event === null || event === void 0 ? void 0 : event.stopPropagation();
    }
  }));
  const alertDataResults = data === null || data === void 0 ? void 0 : (_data$hits = data.hits) === null || _data$hits === void 0 ? void 0 : (_data$hits$hits = _data$hits.hits) === null || _data$hits$hits === void 0 ? void 0 : _data$hits$hits.map(item => {
    var _item$fields, _item$fields$_id, _item$fields2, _item$fields2$_index, _item$fields3, _item$fields3$KIBANA_, _item$fields4, _item$fields4$KIBANA_, _item$fields5, _item$fields5$KIBANA_;
    return {
      id: (_item$fields = item.fields) === null || _item$fields === void 0 ? void 0 : (_item$fields$_id = _item$fields._id) === null || _item$fields$_id === void 0 ? void 0 : _item$fields$_id[0],
      index: (_item$fields2 = item.fields) === null || _item$fields2 === void 0 ? void 0 : (_item$fields2$_index = _item$fields2._index) === null || _item$fields2$_index === void 0 ? void 0 : _item$fields2$_index[0],
      [KIBANA_ALERTS.RULE_NAME]: (_item$fields3 = item.fields) === null || _item$fields3 === void 0 ? void 0 : (_item$fields3$KIBANA_ = _item$fields3[KIBANA_ALERTS.RULE_NAME]) === null || _item$fields3$KIBANA_ === void 0 ? void 0 : _item$fields3$KIBANA_[0],
      [KIBANA_ALERTS.SEVERITY]: (_item$fields4 = item.fields) === null || _item$fields4 === void 0 ? void 0 : (_item$fields4$KIBANA_ = _item$fields4[KIBANA_ALERTS.SEVERITY]) === null || _item$fields4$KIBANA_ === void 0 ? void 0 : _item$fields4$KIBANA_[0],
      [KIBANA_ALERTS.WORKFLOW_STATUS]: (_item$fields5 = item.fields) === null || _item$fields5 === void 0 ? void 0 : (_item$fields5$KIBANA_ = _item$fields5[KIBANA_ALERTS.WORKFLOW_STATUS]) === null || _item$fields5$KIBANA_ === void 0 ? void 0 : _item$fields5$KIBANA_[0]
    };
  });
  const {
    pageOfItems,
    totalItemCount
  } = alertsPagination(alertDataResults || []);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [10, 25, 100]
  };
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      const {
        index,
        size
      } = page;
      setPageIndex(index);
      setPageSize(size);
    }
    if (sort) {
      const {
        field: fieldSort,
        direction
      } = sort;
      setSortField(fieldSort);
      setSortDirection(direction);
      setQuery((0, _helpers.buildEntityAlertsQuery)({
        field,
        to,
        from,
        queryValue: value,
        size: 500,
        severity: currentFilter,
        sortField: fieldSort,
        sortDirection: direction
      }));
    }
  }, [currentFilter, field, from, setQuery, to, value]);
  const {
    openPreviewPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const handleOnEventAlertDetailPanelOpened = (0, _react.useCallback)((eventId, indexName, tableId) => {
    openPreviewPanel({
      id: _panel_keys.DocumentDetailsPreviewPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId: tableId,
        isPreviewMode: true,
        banner: _constants2.ALERT_PREVIEW_BANNER
      }
    });
  }, [openPreviewPanel]);
  const tableId = _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage;
  const columns = [{
    field: 'id',
    name: '',
    width: '5%',
    render: (id, alert) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: () => handleOnEventAlertDetailPanelOpened(id, alert.index, tableId),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'expand',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 13
      }
    }))
  }, {
    field: KIBANA_ALERTS.RULE_NAME,
    render: ruleName => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 39
      }
    }, ruleName),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.alerts.table.ruleNameColumnName', {
      defaultMessage: 'Rule'
    }),
    width: '55%',
    sortable: true
  }, {
    field: KIBANA_ALERTS.SEVERITY,
    render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      value: severity,
      "data-test-subj": "severityPropertyValue",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    })),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.alerts.table.severityColumnName', {
      defaultMessage: 'Severity'
    }),
    width: '20%',
    sortable: true
  }, {
    field: KIBANA_ALERTS.WORKFLOW_STATUS,
    render: status => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 37
      }
    }, (0, _lodash.capitalize)(status)),
    name: _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.alerts.table.statusColumnName', {
      defaultMessage: 'Status'
    }),
    width: '20%',
    sortable: true
  }];
  const openAlertsPageWithFilters = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const openAlertsInAlertsPage = (0, _react.useCallback)(() => openAlertsPageWithFilters([{
    title: field === 'host.name' ? _translations.OPEN_IN_ALERTS_TITLE_HOSTNAME : _translations.OPEN_IN_ALERTS_TITLE_USERNAME,
    selectedOptions: [value],
    fieldName: field
  }, {
    title: _translations.OPEN_IN_ALERTS_TITLE_STATUS,
    selectedOptions: [_types2.FILTER_OPEN, _types2.FILTER_ACKNOWLEDGED],
    fieldName: 'kibana.alert.workflow_status'
  }], true, timerange), [field, openAlertsPageWithFilters, timerange, value]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => openAlertsInAlertsPage(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    "data-test-subj": 'securitySolutionFlyoutInsightsAlertsCount',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.flyout.left.insights.alerts.tableTitle', {
    defaultMessage: 'Alerts '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'popout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: alertStats.reverse(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 373,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems || [],
    rowHeader: "result",
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    "data-test-subj": 'securitySolutionFlyoutMisconfigurationFindingsTable',
    sorting: sorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  })));
});
AlertsDetailsTable.displayName = 'AlertsDetailsTable';