"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _use_columns = require("./use_columns");
var _use_find_schedules = require("../logic/use_find_schedules");
var _use_enable_schedule = require("../logic/use_enable_schedule");
var _use_disable_schedule = require("../logic/use_disable_schedule");
var _use_delete_schedule = require("../logic/use_delete_schedule");
var _details_flyout = require("../details_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/schedules_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const DEFAULT_SORT_FIELD = 'name';
const DEFAULT_SORT_DIRECTION = 'asc';

/**
 * Table Component for displaying Attack Discovery Schedules
 */
const SchedulesTable = exports.SchedulesTable = /*#__PURE__*/_react.default.memo(() => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(DEFAULT_PAGE_SIZE);
  const [sortField, setSortField] = (0, _react.useState)(DEFAULT_SORT_FIELD);
  const [sortDirection, setSortDirection] = (0, _react.useState)(DEFAULT_SORT_DIRECTION);
  const {
    data: {
      schedules,
      total
    } = {
      schedules: [],
      total: 0
    },
    isLoading: isDataLoading
  } = (0, _use_find_schedules.useFindAttackDiscoverySchedules)({
    page: pageIndex,
    perPage: pageSize,
    sortField,
    sortDirection
  });
  const pagination = (0, _react.useMemo)(() => {
    return {
      pageIndex,
      pageSize,
      totalItemCount: total
    };
  }, [pageIndex, pageSize, total]);
  const sorting = (0, _react.useMemo)(() => {
    return {
      sort: {
        field: sortField,
        direction: sortDirection
      }
    };
  }, [sortDirection, sortField]);
  const onTableChange = (0, _react.useCallback)(({
    page,
    sort
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
    }
  }, []);
  const [isTableLoading, setTableLoading] = (0, _react.useState)(false);
  const [scheduleDetailsId, setScheduleDetailsId] = (0, _react.useState)(undefined);
  const {
    mutateAsync: enableAttackDiscoverySchedule
  } = (0, _use_enable_schedule.useEnableAttackDiscoverySchedule)();
  const {
    mutateAsync: disableAttackDiscoverySchedule
  } = (0, _use_disable_schedule.useDisableAttackDiscoverySchedule)();
  const {
    mutateAsync: deleteAttackDiscoverySchedule
  } = (0, _use_delete_schedule.useDeleteAttackDiscoverySchedule)();
  const openScheduleDetails = (0, _react.useCallback)(scheduleId => {
    setScheduleDetailsId(scheduleId);
  }, []);
  const enableSchedule = (0, _react.useCallback)(async id => {
    try {
      setTableLoading(true);
      await enableAttackDiscoverySchedule({
        id
      });
    } catch (err) {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setTableLoading(false);
    }
  }, [enableAttackDiscoverySchedule]);
  const disableSchedule = (0, _react.useCallback)(async id => {
    try {
      setTableLoading(true);
      await disableAttackDiscoverySchedule({
        id
      });
    } catch (err) {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setTableLoading(false);
    }
  }, [disableAttackDiscoverySchedule]);
  const deleteSchedule = (0, _react.useCallback)(async id => {
    try {
      setTableLoading(true);
      await deleteAttackDiscoverySchedule({
        id
      });
    } catch (err) {
      // Error is handled by the mutation's onError callback, so no need to do anything here
    } finally {
      setTableLoading(false);
    }
  }, [deleteAttackDiscoverySchedule]);
  const rulesColumns = (0, _use_columns.useColumns)({
    isDisabled: isDataLoading,
    isLoading: isTableLoading,
    openScheduleDetails,
    enableSchedule,
    disableSchedule,
    deleteSchedule
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "schedulesTableContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "schedulesTableDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, i18n.ATTACK_DISCOVER_SCHEDULES_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: isTableLoading,
    items: schedules,
    pagination: pagination,
    sorting: sorting,
    onChange: onTableChange,
    itemId: 'id',
    "data-test-subj": 'schedulesTable',
    columns: rulesColumns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), scheduleDetailsId && /*#__PURE__*/_react.default.createElement(_details_flyout.DetailsFlyout, {
    scheduleId: scheduleDetailsId,
    onClose: () => setScheduleDetailsId(undefined),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }));
});
SchedulesTable.displayName = 'SchedulesTable';